/* 
** Write debugging information into log-file.
**
** This library and program is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public
** License as published by the Free Software Foundation; either
** version 2 of the License, or (at your option) any later version.
**   
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
**
** You should have received a copy of the GNU Library General Public
** License along with this library; if not, write to the Free
** Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
** MA 02111-1307, USA
*/

#ifndef __DAV_DEBUG_H__
#define __DAV_DEBUG_H__

#ifdef DEBUG

#include <argz.h>

#define DBG0(x)   syslog(LOG_MAKEPRI(LOG_DAEMON, LOG_DEBUG), x)
#define DBG1(x, a1)   syslog(LOG_MAKEPRI(LOG_DAEMON, LOG_DEBUG), x, a1)
#define DBG2(x, a1, a2)   syslog(LOG_MAKEPRI(LOG_DAEMON, LOG_DEBUG), x, a1, a2)

#define DBG_PATH(n, m) do { \
    char *dbg_path = strcat_path(n, m); \
    if (strlen(dbg_path) > 0) { \
        syslog(LOG_MAKEPRI(LOG_DAEMON, LOG_DEBUG), "  %s", dbg_path); \
    } else { \
        syslog(LOG_MAKEPRI(LOG_DAEMON, LOG_DEBUG), "  root"); \
    } \
    free(dbg_path); \
} while (0)

#define DBG_ARGS(x) do { \
    DBG1("  Arguments after parsing %s:", x); \
    DBG1("    dav_group = %i", args->dav_group); \
    DBG1("    conf = %s", args->conf); \
    DBG1("    mpoint = %s", args->mpoint); \
    DBG1("    user = %i", args->user); \
    DBG1("    mopts = %#lx", args->mopts); \
    DBG1("    uid = %i", args->uid); \
    DBG1("    gid = %i", args->gid); \
    DBG1("    dir_umask = %#o", args->dir_umask); \
    DBG1("    file_umask = %#o", args->file_umask); \
    DBG1("    dir_mode = %#o", args->dir_mode); \
    DBG1("    file_mode = %#o", args->file_mode); \
    DBG1("    url = %s", args->url); \
    DBG1("    secrets = %s", args->secrets); \
    DBG1("    p_host = %s", args->p_host); \
    DBG1("    p_port = %i", args->p_port); \
    DBG1("    useproxy = %i", args->useproxy); \
    DBG1("    askauth = %i", args->askauth); \
    DBG1("    locks = %i", args->locks); \
    DBG1("    read_timeout = %li s", args->read_timeout); \
    DBG1("    sys_cache = %s", args->sys_cache); \
    DBG1("    cache_dir = %s", args->cache_dir); \
    DBG1("    cache_size = %i Byte", args->cache_size); \
    DBG1("    table_size = %i", args->table_size); \
    DBG1("    idle_time = %li s", args->idle_time); \
    DBG1("    expire = %li s", args->expire); \
    DBG1("    retry = %li s", args->retry); \
    DBG1("    max_retry = %li s", args->max_retry); \
} while (0)

#define DBG_CMDLINE(x) do { \
    size_t len; \
    char * cmdline; \
    if (argz_create(x, &cmdline, &len) == 0) { \
        argz_stringify(cmdline, len, ' '); \
        DBG1("  %s", cmdline); \
        NE_FREE(cmdline); \
    } \
} while (0)

#else /* DEBUG */

#define DBG0(x) 
#define DBG1(x, a1)
#define DBG2(x, a1, a2)
#define DBG_PATH(n, m)
#define DBG_ARGS(x)
#define DBG_CMDLINE(x)

#endif /* DEBUG */


#ifdef DEBUG_SECRETS
#define DBG_SECRETS do { \
    DBG0("  Credentials:"); \
    DBG1("    username = %s", args->username); \
    DBG1("    passord = %s", args->password); \
    DBG1("    p_user = %s", args->p_user); \
    DBG1("    p_passord = %s", args->p_passwd); \
} while (0)
#else /* DEBUG_SECRETS */
#define DBG_SECRETS
#endif /* DEBUG_SECRETS */

#endif
