/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4oUnit.Tests
{
	public class AssertTestCase : Db4oUnit.ITestCase
	{
		public virtual void TestAreEqual()
		{
			Db4oUnit.Assert.AreEqual(true, true);
			Db4oUnit.Assert.AreEqual(42, 42);
			Db4oUnit.Assert.AreEqual(42, 42);
			Db4oUnit.Assert.AreEqual(null, null);
			ExpectFailure(new _AnonymousInnerClass14(this));
			ExpectFailure(new _AnonymousInnerClass19(this));
			ExpectFailure(new _AnonymousInnerClass24(this));
			ExpectFailure(new _AnonymousInnerClass29(this));
		}

		private sealed class _AnonymousInnerClass14 : Db4oUnit.ICodeBlock
		{
			public _AnonymousInnerClass14(AssertTestCase _enclosing)
			{
				this._enclosing = _enclosing;
			}

			public void Run()
			{
				Db4oUnit.Assert.AreEqual(true, false);
			}

			private readonly AssertTestCase _enclosing;
		}

		private sealed class _AnonymousInnerClass19 : Db4oUnit.ICodeBlock
		{
			public _AnonymousInnerClass19(AssertTestCase _enclosing)
			{
				this._enclosing = _enclosing;
			}

			public void Run()
			{
				Db4oUnit.Assert.AreEqual(42, 43);
			}

			private readonly AssertTestCase _enclosing;
		}

		private sealed class _AnonymousInnerClass24 : Db4oUnit.ICodeBlock
		{
			public _AnonymousInnerClass24(AssertTestCase _enclosing)
			{
				this._enclosing = _enclosing;
			}

			public void Run()
			{
				Db4oUnit.Assert.AreEqual(new object(), new object());
			}

			private readonly AssertTestCase _enclosing;
		}

		private sealed class _AnonymousInnerClass29 : Db4oUnit.ICodeBlock
		{
			public _AnonymousInnerClass29(AssertTestCase _enclosing)
			{
				this._enclosing = _enclosing;
			}

			public void Run()
			{
				Db4oUnit.Assert.AreEqual(null, new object());
			}

			private readonly AssertTestCase _enclosing;
		}

		public virtual void TestAreSame()
		{
			ExpectFailure(new _AnonymousInnerClass37(this));
			Db4oUnit.Assert.AreSame(this, this);
		}

		private sealed class _AnonymousInnerClass37 : Db4oUnit.ICodeBlock
		{
			public _AnonymousInnerClass37(AssertTestCase _enclosing)
			{
				this._enclosing = _enclosing;
			}

			public void Run()
			{
				Db4oUnit.Assert.AreSame(new object(), new object());
			}

			private readonly AssertTestCase _enclosing;
		}

		private void ExpectFailure(Db4oUnit.ICodeBlock block)
		{
			Db4oUnit.Assert.Expect(typeof(Db4oUnit.AssertionException), block);
		}
	}
}
