/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Assorted
{
	public class PreventMultipleOpenTestCase : Db4oUnit.Extensions.AbstractDb4oTestCase
	{
		private static readonly string FILE = "PreventMultipleOpenTestCase.db4o";

		public static void Main(string[] args)
		{
			new Db4objects.Db4o.Tests.Common.Assorted.PreventMultipleOpenTestCase().RunSolo();
		}

		protected override void Db4oCustomTearDown()
		{
			Db4objects.Db4o.Foundation.IO.File4.Delete(FILE);
			base.Db4oCustomTearDown();
		}

		public virtual void TestOpenTwice()
		{
			Db4objects.Db4o.IObjectContainer oc = Db4objects.Db4o.Db4oFactory.OpenFile(FILE);
			Db4oUnit.Assert.Expect(typeof(Db4objects.Db4o.Ext.DatabaseFileLockedException), new 
				_AnonymousInnerClass31(this));
			KeepAlive(oc);
			oc.Close();
		}

		private sealed class _AnonymousInnerClass31 : Db4oUnit.ICodeBlock
		{
			public _AnonymousInnerClass31(PreventMultipleOpenTestCase _enclosing)
			{
				this._enclosing = _enclosing;
			}

			public void Run()
			{
				Db4objects.Db4o.Db4oFactory.OpenFile(Db4objects.Db4o.Tests.Common.Assorted.PreventMultipleOpenTestCase
					.FILE);
			}

			private readonly PreventMultipleOpenTestCase _enclosing;
		}

		public virtual void TestReopen()
		{
			Db4objects.Db4o.IObjectContainer oc = Db4objects.Db4o.Db4oFactory.OpenFile(FILE);
			oc.Close();
			oc = Db4objects.Db4o.Db4oFactory.OpenFile(FILE);
			Db4oUnit.Assert.IsNotNull(oc);
			oc.Close();
		}

		private void KeepAlive(Db4objects.Db4o.IObjectContainer oc)
		{
		}
	}
}
