/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Foundation
{
	public class Queue4TestCase : Db4oUnit.ITestCase
	{
		public virtual void TestIterator()
		{
			Db4objects.Db4o.Foundation.Queue4 queue = new Db4objects.Db4o.Foundation.Queue4();
			string[] data = { "a", "b", "c", "d" };
			for (int idx = 0; idx < data.Length; idx++)
			{
				AssertIterator(queue, data, idx);
				queue.Add(data[idx]);
				AssertIterator(queue, data, idx + 1);
			}
		}

		private void AssertIterator(Db4objects.Db4o.Foundation.Queue4 queue, string[] data
			, int size)
		{
			System.Collections.IEnumerator iter = queue.Iterator();
			for (int idx = 0; idx < size; idx++)
			{
				Db4oUnit.Assert.IsTrue(iter.MoveNext(), "should be able to move in iteration #" +
					 idx + " of " + size);
				Db4oUnit.Assert.AreEqual(data[idx], iter.Current);
			}
			Db4oUnit.Assert.IsFalse(iter.MoveNext());
		}
	}
}
