/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Soda.Experiments
{
	public class STIdentityEvaluationTestCase : Db4objects.Db4o.Tests.Common.Soda.Util.SodaBaseTestCase
	{
		public override object[] CreateData()
		{
			Db4objects.Db4o.Tests.Common.Soda.Experiments.STIdentityEvaluationTestCase.Helper
				 helperA = new Db4objects.Db4o.Tests.Common.Soda.Experiments.STIdentityEvaluationTestCase.Helper
				("aaa");
			return new object[] { new Db4objects.Db4o.Tests.Common.Soda.Experiments.STIdentityEvaluationTestCase
				(null), new Db4objects.Db4o.Tests.Common.Soda.Experiments.STIdentityEvaluationTestCase
				(helperA), new Db4objects.Db4o.Tests.Common.Soda.Experiments.STIdentityEvaluationTestCase
				(helperA), new Db4objects.Db4o.Tests.Common.Soda.Experiments.STIdentityEvaluationTestCase
				(helperA), new Db4objects.Db4o.Tests.Common.Soda.Experiments.STIdentityEvaluationTestCase
				(new Db4objects.Db4o.Tests.Common.Soda.Experiments.STIdentityEvaluationTestCase.HelperDerivate
				("bbb")), new Db4objects.Db4o.Tests.Common.Soda.Experiments.STIdentityEvaluationTestCase
				(new Db4objects.Db4o.Tests.Common.Soda.Experiments.STIdentityEvaluationTestCase.Helper
				("dod")) };
		}

		public Db4objects.Db4o.Tests.Common.Soda.Experiments.STIdentityEvaluationTestCase.Helper
			 helper;

		public STIdentityEvaluationTestCase()
		{
		}

		public STIdentityEvaluationTestCase(Db4objects.Db4o.Tests.Common.Soda.Experiments.STIdentityEvaluationTestCase.Helper
			 h)
		{
			this.helper = h;
		}

		public virtual void Test()
		{
			Db4objects.Db4o.Query.IQuery q = NewQuery();
			q.Constrain(new Db4objects.Db4o.Tests.Common.Soda.Experiments.STIdentityEvaluationTestCase.Helper
				("aaa"));
			Db4objects.Db4o.IObjectSet os = q.Execute();
			Db4objects.Db4o.Tests.Common.Soda.Experiments.STIdentityEvaluationTestCase.Helper
				 helperA = (Db4objects.Db4o.Tests.Common.Soda.Experiments.STIdentityEvaluationTestCase.Helper
				)os.Next();
			q = NewQuery();
			q.Constrain(typeof(Db4objects.Db4o.Tests.Common.Soda.Experiments.STIdentityEvaluationTestCase)
				);
			q.Descend("helper").Constrain(helperA).Identity();
			q.Constrain(new _AnonymousInnerClass42(this));
			Expect(q, new int[] { 1, 2, 3 });
		}

		private sealed class _AnonymousInnerClass42 : Db4objects.Db4o.Query.IEvaluation
		{
			public _AnonymousInnerClass42(STIdentityEvaluationTestCase _enclosing)
			{
				this._enclosing = _enclosing;
			}

			public void Evaluate(Db4objects.Db4o.Query.ICandidate candidate)
			{
				candidate.Include(true);
			}

			private readonly STIdentityEvaluationTestCase _enclosing;
		}

		public virtual void TestMemberClassConstraint()
		{
			Db4objects.Db4o.Query.IQuery q = NewQuery();
			q.Constrain(typeof(Db4objects.Db4o.Tests.Common.Soda.Experiments.STIdentityEvaluationTestCase)
				);
			q.Descend("helper").Constrain(typeof(Db4objects.Db4o.Tests.Common.Soda.Experiments.STIdentityEvaluationTestCase.HelperDerivate)
				);
			Expect(q, new int[] { 4 });
		}

		public class Helper
		{
			public string hString;

			public Helper()
			{
			}

			public Helper(string str)
			{
				hString = str;
			}
		}

		public class HelperDerivate : Db4objects.Db4o.Tests.Common.Soda.Experiments.STIdentityEvaluationTestCase.Helper
		{
			public HelperDerivate()
			{
			}

			public HelperDerivate(string str) : base(str)
			{
			}
		}
	}
}
