/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Defragment
{
	/// <summary>
	/// First step in the defragmenting process: Allocates pointer slots in the target file for
	/// each ID (but doesn't fill them in, yet) and registers the mapping from source pointer address
	/// to target pointer address.
	/// </summary>
	/// <remarks>
	/// First step in the defragmenting process: Allocates pointer slots in the target file for
	/// each ID (but doesn't fill them in, yet) and registers the mapping from source pointer address
	/// to target pointer address.
	/// </remarks>
	/// <exclude></exclude>
	internal sealed class FirstPassCommand : Db4objects.Db4o.Defragment.IPassCommand
	{
		private const int ID_BATCH_SIZE = 4096;

		private Db4objects.Db4o.Internal.TreeInt _ids;

		internal void Process(Db4objects.Db4o.Defragment.DefragContextImpl context, int objectID
			, bool isClassID)
		{
			if (BatchFull())
			{
				Flush(context);
			}
			_ids = Db4objects.Db4o.Internal.TreeInt.Add(_ids, (isClassID ? -objectID : objectID
				));
		}

		private bool BatchFull()
		{
			return _ids != null && _ids.Size() == ID_BATCH_SIZE;
		}

		public void ProcessClass(Db4objects.Db4o.Defragment.DefragContextImpl context, Db4objects.Db4o.Internal.ClassMetadata
			 yapClass, int id, int classIndexID)
		{
			Process(context, id, true);
			for (int fieldIdx = 0; fieldIdx < yapClass.i_fields.Length; fieldIdx++)
			{
				Db4objects.Db4o.Internal.FieldMetadata field = yapClass.i_fields[fieldIdx];
				if (!field.IsVirtual() && field.HasIndex())
				{
					ProcessBTree(context, field.GetIndex(context.SystemTrans()));
				}
			}
		}

		public void ProcessObjectSlot(Db4objects.Db4o.Defragment.DefragContextImpl context
			, Db4objects.Db4o.Internal.ClassMetadata yapClass, int sourceID, bool registerAddresses
			)
		{
			Process(context, sourceID, false);
		}

		public void ProcessClassCollection(Db4objects.Db4o.Defragment.DefragContextImpl context
			)
		{
			Process(context, context.SourceClassCollectionID(), false);
		}

		public void ProcessBTree(Db4objects.Db4o.Defragment.DefragContextImpl context, Db4objects.Db4o.Internal.Btree.BTree
			 btree)
		{
			Process(context, btree.GetID(), false);
			context.TraverseAllIndexSlots(btree, new _AnonymousInnerClass54(this, context));
		}

		private sealed class _AnonymousInnerClass54 : Db4objects.Db4o.Foundation.IVisitor4
		{
			public _AnonymousInnerClass54(FirstPassCommand _enclosing, Db4objects.Db4o.Defragment.DefragContextImpl
				 context)
			{
				this._enclosing = _enclosing;
				this.context = context;
			}

			public void Visit(object obj)
			{
				int id = ((int)obj);
				this._enclosing.Process(context, id, false);
			}

			private readonly FirstPassCommand _enclosing;

			private readonly Db4objects.Db4o.Defragment.DefragContextImpl context;
		}

		public void Flush(Db4objects.Db4o.Defragment.DefragContextImpl context)
		{
			if (_ids == null)
			{
				return;
			}
			int blockSize = context.BlockSize();
			int blockLength = System.Math.Max(Db4objects.Db4o.Internal.Const4.POINTER_LENGTH, 
				blockSize);
			bool overlapping = (Db4objects.Db4o.Internal.Const4.POINTER_LENGTH % blockSize > 
				0);
			int blocksPerPointer = Db4objects.Db4o.Internal.Const4.POINTER_LENGTH / blockSize;
			if (overlapping)
			{
				blocksPerPointer++;
			}
			int batchSize = _ids.Size() * blockLength;
			int pointerAddress = context.AllocateTargetSlot(batchSize);
			System.Collections.IEnumerator idIter = new Db4objects.Db4o.Foundation.TreeKeyIterator
				(_ids);
			while (idIter.MoveNext())
			{
				int objectID = ((int)idIter.Current);
				bool isClassID = false;
				if (objectID < 0)
				{
					objectID = -objectID;
					isClassID = true;
				}
				context.MapIDs(objectID, pointerAddress, isClassID);
				pointerAddress += blocksPerPointer;
			}
			_ids = null;
		}
	}
}
