/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Internal.CS
{
	/// <exclude></exclude>
	public class LazyClientQueryResult : Db4objects.Db4o.Internal.Query.Result.AbstractQueryResult
	{
		private const int SIZE_NOT_SET = -1;

		private readonly Db4objects.Db4o.Internal.CS.ClientObjectContainer _client;

		private readonly int _queryResultID;

		private int _size = SIZE_NOT_SET;

		private readonly Db4objects.Db4o.Internal.CS.LazyClientIdIterator _iterator;

		public LazyClientQueryResult(Db4objects.Db4o.Internal.Transaction trans, Db4objects.Db4o.Internal.CS.ClientObjectContainer
			 client, int queryResultID) : base(trans)
		{
			_client = client;
			_queryResultID = queryResultID;
			_iterator = new Db4objects.Db4o.Internal.CS.LazyClientIdIterator(this);
		}

		public override object Get(int index)
		{
			lock (Lock())
			{
				return ActivatedObject(GetId(index));
			}
		}

		public override int GetId(int index)
		{
			return AskServer(Db4objects.Db4o.Internal.CS.Messages.Msg.OBJECTSET_GET_ID, index
				);
		}

		public override int IndexOf(int id)
		{
			return AskServer(Db4objects.Db4o.Internal.CS.Messages.Msg.OBJECTSET_INDEXOF, id);
		}

		private int AskServer(Db4objects.Db4o.Internal.CS.Messages.MsgD message, int param
			)
		{
			_client.WriteMsg(message.GetWriterForInts(_transaction, new int[] { _queryResultID
				, param }));
			return ((Db4objects.Db4o.Internal.CS.Messages.MsgD)_client.ExpectedResponse(message
				)).ReadInt();
		}

		public override Db4objects.Db4o.Foundation.IIntIterator4 IterateIDs()
		{
			return _iterator;
		}

		public override System.Collections.IEnumerator GetEnumerator()
		{
			return new Db4objects.Db4o.Internal.CS.ClientQueryResultIterator(this);
		}

		public override int Size()
		{
			if (_size == SIZE_NOT_SET)
			{
				_client.WriteMsg(Db4objects.Db4o.Internal.CS.Messages.Msg.OBJECTSET_SIZE.GetWriterForInt
					(_transaction, _queryResultID));
				_size = ((Db4objects.Db4o.Internal.CS.Messages.MsgD)_client.ExpectedResponse(Db4objects.Db4o.Internal.CS.Messages.Msg
					.OBJECTSET_SIZE)).ReadInt();
			}
			return _size;
		}

		~LazyClientQueryResult()
		{
			_client.WriteMsg(Db4objects.Db4o.Internal.CS.Messages.Msg.OBJECTSET_FINALIZED.GetWriterForInt
				(_transaction, _queryResultID));
		}

		public override void LoadFromIdReader(Db4objects.Db4o.Internal.Buffer reader)
		{
			_iterator.LoadFromIdReader(reader, reader.ReadInt());
		}

		public virtual void Reset()
		{
			_client.WriteMsg(Db4objects.Db4o.Internal.CS.Messages.Msg.OBJECTSET_RESET.GetWriterForInt
				(_transaction, _queryResultID));
		}

		public virtual void FetchIDs(int batchSize)
		{
			_client.WriteMsg(Db4objects.Db4o.Internal.CS.Messages.Msg.OBJECTSET_FETCH.GetWriterForInts
				(_transaction, new int[] { _queryResultID, batchSize }));
			Db4objects.Db4o.Internal.Buffer reader = _client.ExpectedByteResponse(Db4objects.Db4o.Internal.CS.Messages.Msg
				.ID_LIST);
			LoadFromIdReader(reader);
		}
	}
}
