/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Internal
{
	/// <exclude></exclude>
	public sealed class EventDispatcher
	{
		private static readonly string[] events = { "objectCanDelete", "objectOnDelete", 
			"objectOnActivate", "objectOnDeactivate", "objectOnNew", "objectOnUpdate", "objectCanActivate"
			, "objectCanDeactivate", "objectCanNew", "objectCanUpdate" };

		internal const int CAN_DELETE = 0;

		internal const int DELETE = 1;

		internal const int SERVER_COUNT = 2;

		internal const int ACTIVATE = 2;

		internal const int DEACTIVATE = 3;

		internal const int NEW = 4;

		public const int UPDATE = 5;

		internal const int CAN_ACTIVATE = 6;

		internal const int CAN_DEACTIVATE = 7;

		internal const int CAN_NEW = 8;

		internal const int CAN_UPDATE = 9;

		internal const int COUNT = 10;

		private readonly Db4objects.Db4o.Reflect.IReflectMethod[] methods;

		private EventDispatcher(Db4objects.Db4o.Reflect.IReflectMethod[] methods_)
		{
			methods = methods_;
		}

		internal bool Dispatch(Db4objects.Db4o.Internal.ObjectContainerBase stream, object
			 obj, int eventID)
		{
			if (methods[eventID] != null)
			{
				object[] parameters = new object[] { stream };
				int stackDepth = stream.StackDepth();
				int topLevelCallId = stream.TopLevelCallId();
				stream.StackDepth(0);
				try
				{
					object res = methods[eventID].Invoke(obj, parameters);
					if (res != null && res is bool)
					{
						return ((bool)res);
					}
				}
				catch
				{
				}
				finally
				{
					stream.StackDepth(stackDepth);
					stream.TopLevelCallId(topLevelCallId);
				}
			}
			return true;
		}

		internal static Db4objects.Db4o.Internal.EventDispatcher ForClass(Db4objects.Db4o.Internal.ObjectContainerBase
			 a_stream, Db4objects.Db4o.Reflect.IReflectClass classReflector)
		{
			if (a_stream == null || classReflector == null)
			{
				return null;
			}
			Db4objects.Db4o.Internal.EventDispatcher dispatcher = null;
			int count = 0;
			if (a_stream.ConfigImpl().Callbacks())
			{
				count = COUNT;
			}
			else
			{
				if (a_stream.ConfigImpl().IsServer())
				{
					count = SERVER_COUNT;
				}
			}
			if (count > 0)
			{
				Db4objects.Db4o.Reflect.IReflectClass[] parameterClasses = { a_stream.i_handlers.
					ICLASS_OBJECTCONTAINER };
				Db4objects.Db4o.Reflect.IReflectMethod[] methods = new Db4objects.Db4o.Reflect.IReflectMethod
					[COUNT];
				for (int i = COUNT - 1; i >= 0; i--)
				{
					try
					{
						Db4objects.Db4o.Reflect.IReflectMethod method = classReflector.GetMethod(events[i
							], parameterClasses);
						if (null == method)
						{
							method = classReflector.GetMethod(ToPascalCase(events[i]), parameterClasses);
						}
						if (method != null)
						{
							methods[i] = method;
							if (dispatcher == null)
							{
								dispatcher = new Db4objects.Db4o.Internal.EventDispatcher(methods);
							}
						}
					}
					catch
					{
					}
				}
			}
			return dispatcher;
		}

		private static string ToPascalCase(string name)
		{
			return Sharpen.Runtime.Substring(name, 0, 1).ToUpper() + Sharpen.Runtime.Substring
				(name, 1);
		}
	}
}
