/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Internal.Freespace
{
	internal abstract class FreespaceIx
	{
		internal Db4objects.Db4o.Internal.IX.Index4 _index;

		internal Db4objects.Db4o.Internal.IX.IndexTransaction _indexTrans;

		internal Db4objects.Db4o.Internal.IX.IxTraverser _traverser;

		internal Db4objects.Db4o.Internal.Freespace.FreespaceVisitor _visitor;

		internal FreespaceIx(Db4objects.Db4o.Internal.LocalObjectContainer file, Db4objects.Db4o.MetaIndex
			 metaIndex)
		{
			_index = new Db4objects.Db4o.Internal.IX.Index4(file.GetSystemTransaction(), new 
				Db4objects.Db4o.Internal.Handlers.IntHandler(file), metaIndex, false);
			_indexTrans = _index.GlobalIndexTransaction();
		}

		internal abstract void Add(int address, int length);

		internal abstract int Address();

		public virtual void Debug()
		{
		}

		public virtual int EntryCount()
		{
			return Db4objects.Db4o.Foundation.Tree.Size(_indexTrans.GetRoot());
		}

		internal virtual void Find(int val)
		{
			_traverser = new Db4objects.Db4o.Internal.IX.IxTraverser();
			_traverser.FindBoundsExactMatch(val, (Db4objects.Db4o.Internal.IX.IxTree)_indexTrans
				.GetRoot());
		}

		internal abstract int Length();

		internal virtual bool Match()
		{
			_visitor = new Db4objects.Db4o.Internal.Freespace.FreespaceVisitor();
			_traverser.VisitMatch(_visitor);
			return _visitor.Visited();
		}

		internal virtual bool Preceding()
		{
			_visitor = new Db4objects.Db4o.Internal.Freespace.FreespaceVisitor();
			_traverser.VisitPreceding(_visitor);
			return _visitor.Visited();
		}

		internal abstract void Remove(int address, int length);

		internal virtual bool Subsequent()
		{
			_visitor = new Db4objects.Db4o.Internal.Freespace.FreespaceVisitor();
			_traverser.VisitSubsequent(_visitor);
			return _visitor.Visited();
		}

		public virtual void Traverse(Db4objects.Db4o.Foundation.IVisitor4 visitor)
		{
			Db4objects.Db4o.Foundation.Tree.Traverse(_indexTrans.GetRoot(), visitor);
		}
	}
}
