/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Nativequery.Expr
{
	public class ComparisonExpression : Db4objects.Db4o.Nativequery.Expr.IExpression
	{
		private Db4objects.Db4o.Nativequery.Expr.Cmp.FieldValue _left;

		private Db4objects.Db4o.Nativequery.Expr.Cmp.IComparisonOperand _right;

		private Db4objects.Db4o.Nativequery.Expr.Cmp.ComparisonOperator _op;

		public ComparisonExpression(Db4objects.Db4o.Nativequery.Expr.Cmp.FieldValue left, 
			Db4objects.Db4o.Nativequery.Expr.Cmp.IComparisonOperand right, Db4objects.Db4o.Nativequery.Expr.Cmp.ComparisonOperator
			 op)
		{
			if (left == null || right == null || op == null)
			{
				throw new System.ArgumentNullException();
			}
			this._left = left;
			this._right = right;
			this._op = op;
		}

		public virtual Db4objects.Db4o.Nativequery.Expr.Cmp.FieldValue Left()
		{
			return _left;
		}

		public virtual Db4objects.Db4o.Nativequery.Expr.Cmp.IComparisonOperand Right()
		{
			return _right;
		}

		public virtual Db4objects.Db4o.Nativequery.Expr.Cmp.ComparisonOperator Op()
		{
			return _op;
		}

		public override string ToString()
		{
			return _left + " " + _op + " " + _right;
		}

		public override bool Equals(object other)
		{
			if (this == other)
			{
				return true;
			}
			if (other == null || GetType() != other.GetType())
			{
				return false;
			}
			Db4objects.Db4o.Nativequery.Expr.ComparisonExpression casted = (Db4objects.Db4o.Nativequery.Expr.ComparisonExpression
				)other;
			return _left.Equals(casted._left) && _right.Equals(casted._right) && _op.Equals(casted
				._op);
		}

		public override int GetHashCode()
		{
			return (_left.GetHashCode() * 29 + _right.GetHashCode()) * 29 + _op.GetHashCode();
		}

		public virtual void Accept(Db4objects.Db4o.Nativequery.Expr.IExpressionVisitor visitor
			)
		{
			visitor.Visit(this);
		}
	}
}
