package com.db4odoc.marshall;

import com.db4o.config.ObjectMarshaller;
import com.db4o.foundation.PrimitiveCodec;

public class ItemMarshaller implements ObjectMarshaller{

		public void writeFields(Object obj, byte[] slot, int offset) {
			Item item = (Item)obj;
			PrimitiveCodec.writeInt(slot, offset, item._one);
			offset+= PrimitiveCodec.INT_LENGTH;
			PrimitiveCodec.writeLong(slot, offset, item._two);
			offset+= PrimitiveCodec.LONG_LENGTH;
			PrimitiveCodec.writeInt(slot, offset, item._three);
		}
	
		public void readFields(Object obj, byte[] slot, int offset) {
			Item item = (Item)obj;
			item._one = PrimitiveCodec.readInt(slot, offset);
			offset+= PrimitiveCodec.INT_LENGTH;
			item._two = PrimitiveCodec.readLong(slot, offset);
			offset+= PrimitiveCodec.LONG_LENGTH;
			item._three = PrimitiveCodec.readInt(slot, offset);
		}
	
		public int marshalledFieldLength() {
			return PrimitiveCodec.INT_LENGTH * 2 + PrimitiveCodec.LONG_LENGTH;
		}
	}
