/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Foundation
{
	/// <exclude></exclude>
	public class SortedCollection4TestCase : Db4oUnit.ITestCase
	{
		private sealed class _AnonymousInnerClass14 : Db4objects.Db4o.Foundation.IComparison4
		{
			public _AnonymousInnerClass14()
			{
			}

			public int Compare(object x, object y)
			{
				return ((int)x) - ((int)y);
			}
		}

		internal static readonly Db4objects.Db4o.Foundation.IComparison4 INTEGER_COMPARISON
			 = new _AnonymousInnerClass14();

		public virtual void TestAddAllAndToArray()
		{
			object[] array = Db4objects.Db4o.Tests.Common.Foundation.IntArrays4.ToObjectArray
				(new int[] { 6, 4, 1, 2, 7, 3 });
			Db4objects.Db4o.Foundation.SortedCollection4 collection = NewSortedCollection();
			Db4oUnit.Assert.AreEqual(0, collection.Size());
			collection.AddAll(new Db4objects.Db4o.Foundation.ArrayIterator4(array));
			AssertCollection(new int[] { 1, 2, 3, 4, 6, 7 }, collection);
		}

		public virtual void TestToArrayOnEmptyCollection()
		{
			object[] array = new object[0];
			Db4oUnit.Assert.AreSame(array, NewSortedCollection().ToArray(array));
		}

		public virtual void TestAddRemove()
		{
			Db4objects.Db4o.Foundation.SortedCollection4 collection = NewSortedCollection();
			collection.Add(3);
			collection.Add(1);
			collection.Add(5);
			AssertCollection(new int[] { 1, 3, 5 }, collection);
			collection.Remove(3);
			AssertCollection(new int[] { 1, 5 }, collection);
			collection.Remove(1);
			AssertCollection(new int[] { 5 }, collection);
		}

		private void AssertCollection(int[] expected, Db4objects.Db4o.Foundation.SortedCollection4
			 collection)
		{
			Db4oUnit.Assert.AreEqual(expected.Length, collection.Size());
			Db4oUnit.ArrayAssert.AreEqual(Db4objects.Db4o.Tests.Common.Foundation.IntArrays4.
				ToObjectArray(expected), collection.ToArray(new object[collection.Size()]));
		}

		private Db4objects.Db4o.Foundation.SortedCollection4 NewSortedCollection()
		{
			return new Db4objects.Db4o.Foundation.SortedCollection4(INTEGER_COMPARISON);
		}
	}
}
