/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Internal
{
	internal sealed class TranslatedFieldMetadata : Db4objects.Db4o.Internal.FieldMetadata
	{
		private readonly Db4objects.Db4o.Config.IObjectTranslator i_translator;

		internal TranslatedFieldMetadata(Db4objects.Db4o.Internal.ClassMetadata containingClass
			, Db4objects.Db4o.Config.IObjectTranslator translator) : base(containingClass, translator
			)
		{
			i_translator = translator;
			Db4objects.Db4o.Internal.ObjectContainerBase stream = containingClass.GetStream();
			Configure(stream.Reflector().ForClass(translator.StoredClass()), false);
		}

		public override bool CanUseNullBitmap()
		{
			return false;
		}

		internal override void Deactivate(Db4objects.Db4o.Internal.Transaction a_trans, object
			 a_onObject, int a_depth)
		{
			if (a_depth > 0)
			{
				CascadeActivation(a_trans, a_onObject, a_depth, false);
			}
			SetOn(a_trans.Stream(), a_onObject, null);
		}

		public override object GetOn(Db4objects.Db4o.Internal.Transaction a_trans, object
			 a_OnObject)
		{
			try
			{
				return i_translator.OnStore(a_trans.Stream(), a_OnObject);
			}
			catch
			{
				return null;
			}
		}

		public override object GetOrCreate(Db4objects.Db4o.Internal.Transaction a_trans, 
			object a_OnObject)
		{
			return GetOn(a_trans, a_OnObject);
		}

		public override void Instantiate(Db4objects.Db4o.Internal.Marshall.MarshallerFamily
			 mf, Db4objects.Db4o.Internal.ObjectReference a_yapObject, object a_onObject, Db4objects.Db4o.Internal.StatefulBuffer
			 a_bytes)
		{
			object toSet = Read(mf, a_bytes);
			a_bytes.GetStream().Activate1(a_bytes.GetTransaction(), toSet, a_bytes.GetInstantiationDepth
				());
			SetOn(a_bytes.GetStream(), a_onObject, toSet);
		}

		internal override void Refresh()
		{
		}

		private void SetOn(Db4objects.Db4o.Internal.ObjectContainerBase a_stream, object 
			a_onObject, object toSet)
		{
			try
			{
				i_translator.OnActivate(a_stream, a_onObject, toSet);
			}
			catch
			{
			}
		}

		protected override object IndexEntryFor(object indexEntry)
		{
			return indexEntry;
		}

		protected override Db4objects.Db4o.Internal.IX.IIndexable4 IndexHandler(Db4objects.Db4o.Internal.ObjectContainerBase
			 stream)
		{
			return i_handler;
		}
	}
}
