using System;
using System.Collections.Generic;
using System.IO;
using Db4objects.Db4o;
using Db4objects.Db4odoc.ReportsExample.Persistent;

namespace Db4objects.Db4odoc.ReportsExample.Modules
{
    class Db4oManager
    {
        public const string DbFileName = "..//..//Data//formula1.db";
        public static IObjectContainer _db;

        private Db4oManager()
        { 
        }
        // end Db4oManager

        public static void FillUpDB()
        {
            Pilot pilot = new Pilot("Michael Schumacher", 100);
            Db().Set(pilot);
            pilot = new Pilot("David Barichello", 95);
            Db().Set(pilot);
            pilot = new Pilot("Kimi Raikkonen", 100);
            Db().Set(pilot);
        }
        // end FillUpDB

        public static IList<Pilot> GetAllPilots()
        {
            IList<Pilot> result = Db().Query<Pilot>(typeof(Pilot));
            return result;
        }
        // end GetAllPilots

        public static void StoreObject(Object obj)
        {
            Db().Set(obj);
        }
        // end StoreObject

        public static IObjectContainer Db()
        {
            if (_db == null)
            {
                _db = Db4oFactory.OpenFile(DbFileName);
            }
            return _db;
        }
        // end Db

        public static void CloseDb()
        {
            if (_db != null)
            {
                _db.Close();
            }
        }
        // end CloseDb
    }
}
