/* Copyright (C) 2004 - 2007 db4objects Inc. http://www.db4o.com */
using System;
using System.Collections.Generic;

using Db4objects.Db4o;
using Db4objects.Db4o.Config;
using Db4objects.Db4o.Query;

/**
 * This example shows how to use the same db4o database between 
 * Java and .NET application. Pilot objects are originally saved in Java,
 * then they are read and modified in .NET application and read again 
 * in Java
 *
 */

namespace Db4objects.Db4odoc.Aliases
{
    class InterLanguageExample
    {
        private const string Db4oFileName = "reference.db4o";

        public static void Main(string[] args)
        {
            GetObjects(ConfigureAlias());
        }
        // end Main

        private static IConfiguration ConfigureAlias()
        {
            IConfiguration configuration = Db4oFactory.NewConfiguration();
            configuration.AddAlias(new WildcardAlias("com.db4odoc.aliases.*", "Db4objects.Db4odoc.Aliases.*, Db4objects.Db4odoc"));
            configuration.AddAlias(new TypeAlias("com.db4o.ext.Db4oDatabase", "Db4objects.Db4o.Ext.Db4oDatabase, Db4objects.Db4o"));
            return configuration;
        }
        // end ConfigureAlias

        private static void GetObjects(IConfiguration configuration)
        {
            IObjectContainer db = Db4oFactory.OpenFile(configuration, Db4oFileName);
            try
            {
                IList<Pilot> result = db.Query<Pilot>(delegate(Pilot pilot) {
                    return pilot.Points % 2 == 0;
                });
                for (int i = 0; i < result.Count; i++) {
                    Pilot pilot = result[i];
                    pilot.Name = "Modified " + pilot.Name;
                    db.Set(pilot);
                }
                ListResult(result);
            }
            finally
            {
                db.Close();
            }
        }
        // end GetObjects

        private static void ListResult<T>(IList<T> result)
        {
            Console.WriteLine(result.Count);
            for (int i = 0; i < result.Count; i++)
            {
                Console.WriteLine(result[i]);
            }
        }
        // end ListResult
    }
}
