import java.util.HashMap;
import java.util.logging.Level;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineConstants;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;

public class ReportMain {

	private static IReportEngine engine = null;

	private final static String OUTPUT_DIR = "c://Temp";

	private final static String REPORT_DESIGN = "Pilots.rptdesign";

	private final static String REPORT_OUTPUT = "Report.html";

	private final static String BIRT_HOME = "d://birtruntime//birt-runtime-2_1_1//ReportEngine";

	public static void main(String[] args) throws BirtException {
		// create engine configuration
		EngineConfig config = new EngineConfig();
		// specify the path to the BIRT installation 
		config.setEngineHome(BIRT_HOME);
		// set the output directory for the logging and set the logging level
		config.setLogConfig(OUTPUT_DIR, Level.FINE);

		// start the Platform to load the plugins
		Platform.startup(config);
		// create a factory, which will supply ReportEngine instance
		IReportEngineFactory factory = (IReportEngineFactory) Platform
				.createFactoryObject(IReportEngineFactory.EXTENSION_REPORT_ENGINE_FACTORY);
		// there is a significant cost associated with creating a new engine
		// instance, therefore the application should use only one engine instance 
		// for its reports
		engine = factory.createReportEngine(config);
		engine.changeLogLevel(Level.WARNING);

		IReportRunnable design;
		// Open the report design
		design = engine.openReportDesign(REPORT_DESIGN);
		// Create task to run and render the report
		IRunAndRenderTask task = engine.createRunAndRenderTask(design);
		
		// Set rendering options - such as file or stream output,
		// output format, whether it is embeddable, etc
		HTMLRenderOption options = new HTMLRenderOption();
		options.setOutputFileName(OUTPUT_DIR + "//" + REPORT_OUTPUT);
		// output format can be either html or pdf
		options.setOutputFormat("html");
		task.setRenderOption(options);

		// run the report
		task.run();
		task.close();

		// shutdown the engine and the platform after use
		// to clean up and unload the extensions
		engine.shutdown();
		Platform.shutdown();
	}
	// end main
}