' Copyright (C) 2004 - 2007 db4objects Inc. http://www.db4o.com 

Imports System
Imports System.IO
Imports System.IO.IsolatedStorage
Imports Db4objects.Db4o
Imports Db4objects.Db4o.Config

Namespace Db4objects.Db4odoc.IsolatedStorage
    Class IsolatedStorageExample
        Private Const Db4oFileName As String = "reference.db4o"

        Public Shared Sub Main(ByVal args As String())
            TestStore()
            TestRetrieve()
            TestDelete()
            TestRetrieve()
        End Sub
        ' end Main

        Private Shared Sub TestDelete()
            Dim isf As IsolatedStorageFile = IsolatedStorageFile.GetUserStoreForAssembly()
            isf.DeleteFile(Db4oFileName)
        End Sub
        ' end TestDelete

        Private Shared Sub TestStore()
            Dim db As IObjectContainer = Db4oFactory.OpenFile(Configure(), Db4oFileName)
            Try
                Dim pilot As New Pilot("Michael Schumacher")
                db.[Set](pilot)
                System.Console.WriteLine("New pilot added")
            Finally
                db.Close()
            End Try
        End Sub
        ' end TestStore

        Private Shared Function Configure() As IConfiguration
            Dim configuration As IConfiguration = Db4oFactory.NewConfiguration()
            configuration.MessageLevel(1)
            configuration.Io(New IsolatedStorageFileAdapter())
            Return configuration
        End Function
        ' end Configure

        Private Shared Sub TestRetrieve()
            Dim db As IObjectContainer = Db4oFactory.OpenFile(Configure(), Db4oFileName)
            Try
                Dim result As IObjectSet = db.[Get](GetType(Pilot))
                ListResult(result)
            Finally
                db.Close()
            End Try
        End Sub
        ' end TestRetrieve

        Private Shared Sub ListResult(ByVal result As IObjectSet)
            Console.WriteLine(result.Count)
            For Each item As Object In result
                Console.WriteLine(item)
            Next
        End Sub
        ' end ListResult

    End Class
End Namespace