/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using Db4oUnit;
using Db4objects.Db4o;
using Db4objects.Db4o.Ext;
using Db4objects.Db4o.Tests.Common.Assorted;

namespace Db4objects.Db4o.Tests.Common.Assorted
{
	/// <exclude></exclude>
	public class InMemoryObjectContainerTestCase : ITestLifeCycle
	{
		private MemoryFile memoryFile;

		private IObjectContainer objectContainer;

		private static int StoredItems = 1000;

		/// <exception cref="System.Exception"></exception>
		public virtual void SetUp()
		{
			memoryFile = new MemoryFile();
			memoryFile.SetIncrementSizeBy(100);
			memoryFile.SetInitialSize(100);
			objectContainer = ExtDb4oFactory.OpenMemoryFile(memoryFile);
		}

		public class Item
		{
		}

		public virtual void TestSizeIncrement()
		{
			int lastSize = FileSize();
			for (int i = 0; i < StoredItems; i++)
			{
				objectContainer.Store(new InMemoryObjectContainerTestCase.Item());
				Assert.IsSmaller(lastSize + 1000, FileSize());
				lastSize = FileSize();
			}
		}

		private int FileSize()
		{
			return memoryFile.GetBytes().Length;
		}

		/// <exception cref="System.Exception"></exception>
		public virtual void TearDown()
		{
		}
	}
}
