/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using Db4objects.Db4o;
using Db4objects.Db4o.Internal;
using Db4objects.Db4o.Query;

namespace Db4objects.Db4o.Internal.Callbacks
{
	public interface ICallbacks
	{
		bool ObjectCanNew(Transaction transaction, object obj);

		bool ObjectCanActivate(Transaction transaction, object obj);

		bool ObjectCanUpdate(Transaction transaction, object obj);

		bool ObjectCanDelete(Transaction transaction, object obj);

		bool ObjectCanDeactivate(Transaction transaction, object obj);

		void ObjectOnActivate(Transaction transaction, object obj);

		void ObjectOnNew(Transaction transaction, object obj);

		void ObjectOnUpdate(Transaction transaction, object obj);

		void ObjectOnDelete(Transaction transaction, object obj);

		void ObjectOnDeactivate(Transaction transaction, object obj);

		void ObjectOnInstantiate(Transaction transaction, object obj);

		void QueryOnStarted(Transaction transaction, IQuery query);

		void QueryOnFinished(Transaction transaction, IQuery query);

		bool CaresAboutCommitting();

		bool CaresAboutCommitted();

		void ClassOnRegistered(ClassMetadata clazz);

		void CommitOnStarted(Transaction transaction, CallbackObjectInfoCollections objectInfoCollections
			);

		void CommitOnCompleted(Transaction transaction, CallbackObjectInfoCollections objectInfoCollections
			);

		bool CaresAboutDeleting();

		bool CaresAboutDeleted();

		void CloseOnStarted(IObjectContainer container);
	}
}
