#include <string>
#include <iostream>
#include <ace/Log_Msg.h>
#include <ace/Synch.h>

using std::string;

class DBBalancerConfig;

class DBPostgresFrontend {

public:

  DBPostgresFrontend(DBBalancerConfig *config);
  ~DBPostgresFrontend();

  // Private members reading

  inline string getUser() { return _user; }
  inline string getPassword() { return _password; }

  inline char *getKeyPointer() { return _secret_key_response; }
  inline int getKeySize() { return 9; }

  inline char *getBufferPointer() { return _buffer; }
  inline int getBufferSize() { return sizeof(_buffer); }

  inline bool getState() { return _state; }
  inline int getBufferFilling() { return _buffer_filling; }
 
  // Private members writing

  inline void setKey(char *key, int size) { memcpy(_secret_key_response,key,size); }

  // Do things

  // Receives an incoming client connection and checks auth.
  bool receiveStartup(int fe_socket);
  // Reads data from client (when "select" says there's some)
  unsigned int read(int fe_socket);
  // Write error message to FrontEnd
  void writeMessage(int fe_socket, string message1, string message2);
  // Writes data to the BE (when FE has data and is told to write)
  unsigned int writeBack(int be_socket);
 

  // Public consts.

  // Data read results
  const static unsigned int BUFF_DATA = 0;
  const static unsigned int BUFF_MORE = 1;
  const static unsigned int CONN_CLOSED = 2;
  const static unsigned int READ_EXCEPTION = 3;
  const static unsigned int WRITE_EXCEPTION = 4;

  // Auth Modes 

  const static unsigned int TRUSTED_AUTH_MODE = 0;
  const static unsigned int PLAINTEXT_PASSWORD_AUTH_MODE = 3;

  const static unsigned int SEND_FLAGS = 0;
  const static unsigned int RECV_FLAGS = 0;  

private:


  // Private Methods

  bool interceptFrontEndMessage(int size);
  bool handleTrustedAuth(int fe_socket, char *user);
  bool handlePlaintextPasswordAuth(int fe_socket, char *user);

  // General constants.
  const static unsigned int BUFFER_SIZE = 2048;


  // Private attributes.

  // FE connection data.
  string _user;
  string _password;
  string _dbname;
  unsigned int _authMode;

  // Connection state
  char _buffer[BUFFER_SIZE];
  char _secret_key_response[9];
  bool _state;
  int _buffer_filling;

};

