% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBResult.R
\name{dbGetRowsAffected}
\alias{dbGetRowsAffected}
\title{The number of rows affected}
\usage{
dbGetRowsAffected(res, ...)
}
\arguments{
\item{res}{An object inheriting from \linkS4class{DBIResult}.}

\item{...}{Other arguments passed on to methods.}
}
\value{
\code{dbGetRowsAffected()} returns a scalar number (integer or numeric),
the number of rows affected by a data manipulation statement
issued with \code{\link[=dbSendStatement]{dbSendStatement()}}.
The value is available directly after the call
and does not change after calling \code{\link[=dbFetch]{dbFetch()}}.
For queries issued with \code{\link[=dbSendQuery]{dbSendQuery()}},
zero is returned before
and after the call to \code{dbFetch()}.
Attempting to get the rows affected for a result set cleared with
\code{\link[=dbClearResult]{dbClearResult()}} gives an error.
}
\description{
This method returns the number of rows that were added, deleted, or updated
by a data manipulation statement.
}
\examples{
con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbWriteTable(con, "mtcars", mtcars)
rs <- dbSendStatement(con, "DELETE FROM mtcars")
dbGetRowsAffected(rs)
nrow(mtcars)

dbClearResult(rs)
dbDisconnect(con)
}
\seealso{
Other DBIResult generics: \code{\link{DBIResult-class}},
  \code{\link{dbBind}}, \code{\link{dbClearResult}},
  \code{\link{dbColumnInfo}}, \code{\link{dbFetch}},
  \code{\link{dbGetInfo}}, \code{\link{dbGetRowCount}},
  \code{\link{dbGetStatement}},
  \code{\link{dbHasCompleted}}, \code{\link{dbIsValid}},
  \code{\link{dbQuoteIdentifier}},
  \code{\link{dbQuoteString}}
}
