/*
  +----------------------------------------------------------------------+
  | PHP Version 4                                                        |
  +----------------------------------------------------------------------+
  | Copyright (c) 1997-2002 The PHP Group                                |
  +----------------------------------------------------------------------+
  | This source file is subject to version 2.02 of the PHP license,      |
  | that is bundled with this package in the file LICENSE, and is        |
  | available at through the world-wide-web at                           |
  | http://www.php.net/license/2_02.txt.                                 |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Author: Cristian Giussani                                            |
  +----------------------------------------------------------------------+

  $Id: php_dbtcp.h,v 1.3 2002/10/27 14:02:07 flatline Exp $ 
*/

#ifndef PHP_DBTCP_H
#define PHP_DBTCP_H

#if HAVE_DBTCP

#define DBTCP_NUM   1
#define DBTCP_ASSOC 2

extern zend_module_entry dbtcp_module_entry;
#define phpext_dbtcp_ptr &dbtcp_module_entry

#ifdef PHP_WIN32
#define PHP_DBTCP_API __declspec(dllexport)
#else
#define PHP_DBTCP_API
#endif

#ifdef ZTS
#include "TSRM.h"
#endif

PHP_MINIT_FUNCTION(dbtcp);
PHP_MSHUTDOWN_FUNCTION(dbtcp);
PHP_RINIT_FUNCTION(dbtcp);
PHP_RSHUTDOWN_FUNCTION(dbtcp);
PHP_MINFO_FUNCTION(dbtcp);

PHP_FUNCTION(dbtcp_connect);
PHP_FUNCTION(dbtcp_close);
PHP_FUNCTION(dbtcp_sql);
PHP_FUNCTION(dbtcp_fetch);
PHP_FUNCTION(dbtcp_fetch_assoc);
PHP_FUNCTION(dbtcp_field_info);
PHP_FUNCTION(dbtcp_num_fields);
PHP_FUNCTION(dbtcp_error);

/* 
  	Declare any global variables you may need between the BEGIN
	and END macros here:     
*/

ZEND_BEGIN_MODULE_GLOBALS(dbtcp)
	long default_link;
ZEND_END_MODULE_GLOBALS(dbtcp)

/* In every utility function you add that needs to use variables 
   in php_dbtcp_globals, call TSRM_FETCH(); after declaring other 
   variables used by that function, or better yet, pass in TSRMG_CC
   after the last function argument and declare your utility function
   with TSRMG_DC after the last declared argument.  Always refer to
   the globals in your function as DBTCP_G(variable).  You are 
   encouraged to rename these macros something shorter, see
   examples in any other php module directory.
*/

#ifdef ZTS
#define DBTCP_G(v) TSRMG(dbtcp_globals_id, zend_dbtcp_globals *, v)
#else
#define DBTCP_G(v) (dbtcp_globals.v)
#endif

#endif /* HAVE_DBTCP */
#endif	/* PHP_DBTCP_H */


/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: t
 * End:
 */
