#! /usr/local/bin/perl

# test sample Perl interface to the DCC interface daemon

# Copyright (c) 2004 by Rhyolite Software
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND RHYOLITE SOFTWARE DISCLAIMS ALL
# WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL RHYOLITE SOFTWARE
# BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
# OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
# ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
# SOFTWARE.
#	Rhyolite Software DCC 1.2.66-1.5 $Revision$

use strict 'subs', 'vars';
use Getopt::Std;


my($usage);
my(%opts, $clnt_addr, $clnt_name, $rcpt, @rcpts, $body, @result);


do('../dccif.pl') || die("could not get sample interface ../dccif.pl: $!\n");

$usage=("usage: [-h homedir] [-o opts] [-c clnt-name] [-l heLo] [-f env_from]\n"
	. "    [-I infile] [-O outfile]"
	. " [-r rcpt1[:user1][,rcpt2[:user2],...]]\n");

$opts{I} = "-";
$opts{O} = "-";
if (!getopts('h:o:c:l:f:I:O:t:r:', \%opts) || @ARGV) {
    print STDERR $usage;
    exit 1;
}


if (! $opts{c}) {
    $clnt_addr = "";
    $clnt_name = "";
} else {
    $clnt_name = $opts{c};
    $clnt_addr = gethostbyname($clnt_name);
    if (!$clnt_addr) {
	$clnt_addr = "";
    } else {
	$clnt_addr = inet_ntoa($clnt_addr);
	$clnt_name = "" if ($clnt_addr eq $clnt_name);
    }
}


# make array of env_To recipients
#   With no recipients, dccifd will understand a target count of 0.  The
#   result is like `dccifd -Q`.
@rcpts = ();
if ($opts{r}) {
    my(@raw_rcpts, @raw_rcpt);
    @raw_rcpts = split(/,/, $opts{r});
    while (@raw_rcpts) {
	$rcpt = shift(@raw_rcpts);
	$rcpt =~ s/;/\r/;
	push @rcpts, $rcpt;
    }
}

@result = dccif($opts{O},
		$opts{o} ? $opts{o} : "",
		$clnt_addr, $clnt_name,
		$opts{l} ? $opts{l} : "",
		$opts{f} ? $opts{f} : "",
		\@rcpts,
		$opts{I},
		$opts{h} ? $opts{h} : "");

print STDERR "result=@result\n";
