/* Distributed Checksum Clearinghouse heap debugging
 *
 * Copyright (c) 2004 by Rhyolite Software
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND RHYOLITE SOFTWARE DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL RHYOLITE SOFTWARE
 * BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 * Rhyolite Software DCC 1.2.66-1.5 $Revision$
 */

#ifndef DCC_HEAP_DEBUG_H
#define DCC_HEAP_DEBUG_H

#ifdef DEBUG_HEAP
extern void *dcc_malloc(size_t);
extern void *dcc_calloc(size_t, size_t);
extern void dcc_malloc_check(void);
extern char *dcc_strdup(const char *);
extern void dcc_free(void *);
#ifdef UNIX
extern char *malloc_options;
#endif

#else /* DCC_DEBUG_HEAP */
#define dcc_malloc(l) malloc(l)
#define dcc_calloc(l,n) calloc(l,n)
#define dcc_malloc_check()
#define dcc_strdup(s) strdup(s)
#define dcc_free(p) free(p)
#endif

#endif /* DCC_HEAP_DEBUG_H */
