/* Distributed Checksum Clearinghouse
 *
 * server-IDs
 *
 * Copyright (c) 2004 by Rhyolite Software
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND RHYOLITE SOFTWARE DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL RHYOLITE SOFTWARE
 * BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 * Rhyolite Software DCC 1.2.66-1.16 $Revision$
 */

#ifndef DCC_IDS_H
#define DCC_IDS_H

/* IDs file used by server, server utilities, and cdcc */
extern const char *ids_nm;
extern time_t ids_mtime;
#define IDS_NM_DEF  "ids"


/* authenticated client database */
typedef struct id_tbl {
    struct id_tbl *fwd;
    DCC_CLNT_ID	id;
    time_t	delay_us;
#    define	 DCC_ANON_DELAY_US_DEF	(50*1000)
    u_int	delay_inflate;
#    define	 DCC_ANON_INFLATE_OFF	(-1)
    u_char	flags;
#    define	 ID_FLG_MARKED	0x01	/* for garbage collection */
#    define	 ID_FLG_RPT_OK	0x02	/* override dccd -Q */
    DCC_PASSWD	cur_passwd;
    DCC_PASSWD	next_passwd;
} ID_TBL;

extern u_char parse_dccd_delay(DCC_EMSG, time_t *, u_int *,
			       const char *, const char *, int);
extern ID_TBL *find_id_tbl(DCC_CLNT_ID);
extern int load_ids(DCC_EMSG, ID_TBL **, DCC_CLNT_ID);
extern u_char check_load_ids(DCC_EMSG, DCC_CLNT_ID);

#endif /* DCC_IDS_H */
