/* Distributed Checksum Clearinghouse
 *
 * test dccifd via dccif()
 *
 * Copyright (c) 2005 by Rhyolite Software, LLC
 *
 * This agreement is not applicable to any entity which sells anti-spam
 * solutions to others or provides an anti-spam solution as part of a
 * security solution sold to other entities, or to a private network
 * which employs the DCC or uses data provided by operation of the DCC
 * but does not provide corresponding data to other users.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * Parties not eligible to receive a license under this agreement can
 * obtain a commercial license to use DCC and permission to use
 * U.S. Patent 6,330,590 by contacting Commtouch at http://www.commtouch.com/
 * or by email to nospam@commtouch.com.
 *
 * A commercial license would be for Distributed Checksum and Reputation
 * Clearinghouse software.  That software includes additional features.  This
 * free license for Distributed ChecksumClearinghouse Software does not in any
 * way grant permision to use Distributed Checksum and Reputation Clearinghouse
 * software
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND RHYOLITE SOFTWARE, LLC DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL RHYOLITE SOFTWARE, LLC
 * BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 * Rhyolite Software DCC 1.3.42-1.21 $Revision$
 */

#include "dccif.h"
#include "dcc_clnt.h"
#include "dcc_paths.h"
#include <arpa/inet.h>

static void NRATTRIB
usage(void)
{
	dcc_logbad(EX_USAGE,
		   "usage: [-VP] [-h FIFO | homedir | hostname,port] [-o opts]"
		   " [-c clnt-addr]\n"
		   "    [-l heLo] [-f env_from] [-I ifile] [-O ofile]"
		   " [-r rcpt1[,user1]] [...]\n");
}



int NRATTRIB
main(int argc, char **argv)
{
	DCC_EMSG emsg;
	const char *srvr_addr;
	const char *opts;
	DCC_SOCKU su, *sup;
	const char *clnt_nm;
	const char *helo;
	const char *env_from;
	DCCIF_RCPT *rcpts, *rcpt;
	int in_body_fd, out_body_fd;
	u_char dccproc;
	u_char result;
	char *p;
	int i, error;

	srvr_addr = 0;
	opts = 0;
	sup = 0;
	clnt_nm = 0;
	dccproc = 0;
	helo = 0;
	env_from = 0;
	in_body_fd = 0;
	out_body_fd = dup(1);
	rcpts = 0;

	dcc_syslog_init(0, argv[0], 0);

	while (EOF != (i = getopt(argc, argv, "VPh:o:c:l:f:I:O:r:"))) {
		switch (i) {
		case 'V':
			fprintf(stderr, DCC_VERSION"\n");
			break;

		case 'P':
			dccproc = 1;
			dcc_no_syslog = 1;
			break;

		case 'h':
			srvr_addr = optarg;
			break;

		case 'o':
			/* convert commas that users like to type to blanks */
			while ((p = strchr(optarg, ',')) != 0)
				*p = ' ';
			opts = optarg;
			break;

		case 'c':
			clnt_nm = optarg;
			dcc_host_lock();
			if (!dcc_get_host(clnt_nm, 2, &error)) {
				dcc_logbad(EX_USAGE, "%s: %s\n", clnt_nm,
					   DCC_HSTRERROR(error));
			}
			dcc_ipv4sutoipv6(&su, &dcc_hostaddrs[0]);
			sup = &su;
			dcc_host_unlock();
			break;

		case 'l':
			helo = optarg;
			break;

		case 'f':
			env_from = optarg;
			break;

		case 'I':
			close(in_body_fd);
			in_body_fd = open(optarg, O_RDONLY, 0);
			if (in_body_fd < 0)
				dcc_logbad(EX_IOERR, "open(%s): %s\n",
					optarg, strerror(errno));
			break;

		case 'O':
			close(out_body_fd);
			out_body_fd = open(optarg, O_WRONLY | O_CREAT, 0666);
			if (out_body_fd < 0) {
				fprintf(stderr, "open(%s): %s\n",
					optarg, strerror(errno));
				exit(1);
			}
			break;

		case 'r':
			rcpt = malloc(sizeof(*rcpt));
			memset(rcpt, 0, sizeof(*rcpt));
			rcpt->next = rcpts;
			rcpt->addr = optarg;
			p = strchr(optarg, ',');
			if (!p) {
				rcpt->user = "";
			} else {
				*p++ = '\0';
				rcpt->user = p;
			}
			rcpt->ok = '?';
			rcpts = rcpt;
			break;

		default:
			usage();
			break;
		}
	}
	argc -= optind;
	argv += optind;
	if (argc != 0)
		usage();

	result = dccif(emsg,
		       out_body_fd, 0,
		       opts, sup, clnt_nm, helo, env_from,
		       rcpts, in_body_fd, 0, srvr_addr);

	if (!dccproc) {
		if (!result) {
			printf("result 0: %s\n", emsg);
			exit(0);
		}
		printf("overall result = '%c'\n", result);
		for (rcpt = rcpts; rcpt; rcpt = rcpt->next) {
			printf("    %s%s%s: '%c'\n",
			       rcpt->addr,
			       (rcpt->user[0] != '\0') ? "," : "",
			       rcpt->user,
			       rcpt->ok);
		}
		putchar('\n');
	}
	exit(0);
}
