/* Distributed Checksum Clearinghouse
 *
 * unthreaded version of client locking
 *
 * Copyright (c) 2005 by Rhyolite Software, LLC
 *
 * This agreement is not applicable to any entity which sells anti-spam
 * solutions to others or provides an anti-spam solution as part of a
 * security solution sold to other entities, or to a private network
 * which employs the DCC or uses data provided by operation of the DCC
 * but does not provide corresponding data to other users.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * Parties not eligible to receive a license under this agreement can
 * obtain a commercial license to use DCC and permission to use
 * U.S. Patent 6,330,590 by contacting Commtouch at http://www.commtouch.com/
 * or by email to nospam@commtouch.com.
 *
 * A commercial license would be for Distributed Checksum and Reputation
 * Clearinghouse software.  That software includes additional features.  This
 * free license for Distributed ChecksumClearinghouse Software does not in any
 * way grant permision to use Distributed Checksum and Reputation Clearinghouse
 * software
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND RHYOLITE SOFTWARE, LLC DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL RHYOLITE SOFTWARE, LLC
 * BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 * Rhyolite Software DCC 1.3.42-1.41 $Revision$
 */

#include "dcc_ck.h"


/* many POSIX thread implementations have unexpected side effects on
 * ordinary system calls, so don't use the threaded version unless
 * necessary */

u_char grey_on;
u_char grey_query_only;

DCC_WF cmn_wf, cmn_tmp_wf;


void
dcc_ctxts_lock(void)
{
}



void
dcc_ctxts_unlock(void)
{
}



#ifdef DCC_DEBUG_CLNT_LOCK
void
have_ctxts_lock(void)
{
}
#endif



void
dcc_syslog_lock(void)
{
}



void
dcc_syslog_unlock(void)
{
}



u_char dcc_host_locked = 1;

void
dcc_host_lock(void)
{
}



void
dcc_host_unlock(void)
{
}



#ifdef DCC_DEBUG_HEAP
void
dcc_malloc_lock(void)
{
}


void
dcc_malloc_unlock(void)
{
}
#endif /* DCC_DEBUG_HEAP */



#ifndef HAVE_LOCALTIME_R
void
dcc_localtime_lock(void)
{
}



void
dcc_localtime_unlock(void)
{
}
#endif /* HAVE_LOCALTIME_R */



void
dcc_clnt_unthread_init(void)
{
#ifdef DCC_WIN32
	win32_init();
#endif
}


void
dcc_clnt_resolve_mutex_lock(void)
{
}



void
dcc_clnt_resolve_mutex_unlock(void)
{
}



#ifdef DCC_DEBUG_CLNT_LOCK
void
have_clnt_resolve_mutex(void)
{
}
#endif


u_char
dcc_clnt_wake_resolve(void)
{
	return 0;
}



#ifdef DCC_DEBUG_CLNT_LOCK
void
have_cwf_lock(void)
{
}
#endif



u_char
helper_cnt_lock_init(void)
{
	return 0;
}



void
helper_cnt_lock(void)
{
}



void
helper_cnt_unlock(void)
{
}



u_char
helper_recv_lock_init(void)
{
	return 0;
}



void
helper_recv_lock(void)
{
}



void
helper_recv_unlock(void)
{
}


const REPLY *
dnsbl_parse_reply(const char *pat UATTRIB)
{
	return 0;
}
