/* Distributed Checksum Clearinghouse
 *
 * routines for sending messages through external filter for threaded
 *	and unthreaded DCC clients
 *
 * Copyright (c) 2005 by Rhyolite Software, LLC
 *
 * This agreement is not applicable to any entity which sells anti-spam
 * solutions to others or provides an anti-spam solution as part of a
 * security solution sold to other entities, or to a private network
 * which employs the DCC or uses data provided by operation of the DCC
 * but does not provide corresponding data to other users.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * Parties not eligible to receive a license under this agreement can
 * obtain a commercial license to use DCC and permission to use
 * U.S. Patent 6,330,590 by contacting Commtouch at http://www.commtouch.com/
 * or by email to nospam@commtouch.com.
 *
 * A commercial license would be for Distributed Checksum and Reputation
 * Clearinghouse software.  That software includes additional features.  This
 * free license for Distributed ChecksumClearinghouse Software does not in any
 * way grant permision to use Distributed Checksum and Reputation Clearinghouse
 * software
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND RHYOLITE SOFTWARE, LLC DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL RHYOLITE SOFTWARE, LLC
 * BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 * Rhyolite Software DCC 1.3.42-1.20 $Revision$
 */

#include "helper.h"

HELPER_PARENT xfltr_helper_parent;

#define MAX_MSG_SECS 1000		/* total seconds/mail message */
static int xfltr_msg_secs = 20;		/* total seconds/mail message */


/* Parse a string of the form "domain[,[IPaddr][,name|ipv4|ipv6]]"
 *	Strings starting with "set:" are special.
 *	    set:debug=X		more logging
 *	    set:msg_secs=S	total seconds checking blacklists/message
 *	    parm:xxx		external filter parameter
 *
 *	    set:xfltr=soc,fd	start external filter process
 */
u_char					/* 0=bad */
dcc_parse_xfltr(DCC_EMSG emsg, const char *entry)
{
	SOCKET soc;
	int fd;
	int val;

	if (1 == sscanf(entry, "set:debug=%u", &val)) {
		xfltr_helper_parent.debug = val;
		helper_save_arg(1, entry);
		return 1;
	}
	if (1 == sscanf(entry, "set:msg_secs=%u", &val)
	    || 1 == sscanf(entry, "set:msg-secs=%u", &val)) {
		if (val < 1 || val > MAX_MSG_SECS) {
			dcc_pemsg(EX_USAGE, emsg,
				  "bad number of seconds in \"-X %s\"",
				  entry);
			return 0;
		}
		if (xfltr_msg_secs != val) {
			xfltr_msg_secs= val;
			helper_save_arg(1, entry);
		}
		return 1;
	}

	if (2 == sscanf(entry, "set:"HELPER_PAT, &soc, &fd)) {
#ifdef USE_XFLTR
		helper_child(1, soc, fd);
#else
		/* do not give dccproc false hopes */
		dcc_logbad(EX_USAGE,
			   " not supported in this version: \"-X %s\"",
			   entry);
#endif
	}

#ifdef USE_XFLTR
	if (!CSTRCMP(entry, "parm=")) {
		xfltr_parm = entry+STRZ("parm=");
		helper_save_arg(1, entry);
		return 1;
	}
#endif /* USE_XFLTR */

	dcc_pemsg(EX_USAGE, emsg, " not supported in this version: \"-X %s\"",
		  entry);
	return 0;
}



#ifdef USE_XFLTR
u_char					/* 1=spam */
ask_xfltr(DCC_CLNT_CTXT *dcc_ctxt, CMN_WORK *log_ctxt,
	  char *header, int *header_lenp,
	  const char *id,
	  const char *clnt_name, const struct in6_addr *clnt_addr,
	  const char *helo, const char *env_from, int targets,
	  const char *tmp_nm)
{
	XFLTR_REQ req;
	XFLTR_RESP resp;
	struct timeval start;

	memset(&req, 0, sizeof(req));

	req.targets = targets;
	BUFCPY(req.hdr.id, id);
	BUFCPY(req.helo, helo);
	BUFCPY(req.clnt_name, clnt_name);
	req.clnt_addr = *clnt_addr;
	BUFCPY(req.env_from, env_from);
	BUFCPY(req.tmp_nm, tmp_nm);
	gettimeofday(&start, 0);

	if (!ask_helper(dcc_ctxt, 1, log_ctxt,
			&start, xfltr_msg_secs*DCC_USECS,
			&req.hdr, sizeof(req),
			&resp.hdr, sizeof(resp))) {
		header[0] = '\0';
		*header_lenp = 0;
		return 0;
	}

	if (resp.header[0] == '\0') {
		header[0] = '\0';
		*header_lenp = 0;
	} else {
		if (*header_lenp < ISZ(resp.header)
		    || resp.header_len >= ISZ(resp.header)
		    || resp.header[resp.header_len] != '\0'
		    || (resp.header[resp.header_len-1] != '\n'
			&& resp.header_len >= ISZ(resp.header)-1)
		    || resp.header_len >= ISZ(resp.header)
		    || (resp.header[0] != 'X' && resp.header[0] != 'x')
		    || resp.header[1] != '-'
		    || strchr(resp.header, ':') == 0) {
			resp.header[ISZ(resp.header)-1] = '\0';
			thr_error_msg(log_ctxt, "bad external filter header"
				      " \"%s\"", resp.header);
			header[0] = '\0';
			*header_lenp = 0;
		} else {
			if (resp.header[resp.header_len-1] != '\n') {
				resp.header[resp.header_len] = '\n';
				resp.header[++resp.header_len] = '\0';
			}
			memcpy(header, resp.header, resp.header_len+1);
			*header_lenp = resp.header_len;
		}
	}
	return resp.reject;
}
#endif
