/* Distributed Checksum Clearinghouse
 *
 * X-DCC-Warning header definitions
 *
 * Copyright (c) 2005 by Rhyolite Software, LLC
 *
 * This agreement is not applicable to any entity which sells anti-spam
 * solutions to others or provides an anti-spam solution as part of a
 * security solution sold to other entities, or to a private network
 * which employs the DCC or uses data provided by operation of the DCC
 * but does not provide corresponding data to other users.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * Parties not eligible to receive a license under this agreement can
 * obtain a commercial license to use DCC and permission to use
 * U.S. Patent 6,330,590 by contacting Commtouch at http://www.commtouch.com/
 * or by email to nospam@commtouch.com.
 *
 * A commercial license would be for Distributed Checksum and Reputation
 * Clearinghouse software.  That software includes additional features.  This
 * free license for Distributed ChecksumClearinghouse Software does not in any
 * way grant permision to use Distributed Checksum and Reputation Clearinghouse
 * software
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND RHYOLITE SOFTWARE, LLC DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL RHYOLITE SOFTWARE, LLC
 * BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 * Rhyolite Software DCC 1.3.42-1.48 $Revision$
 */

#ifndef DCC_XHDR_H
#define DCC_XHDR_H

/* the DCC SMTP header is of the form
 *
 * X-DCC-name-Metrics: host_addr server-ID; [bulk] cknm1=cnt1 cknm2=cnt2 ...
 *
 * where
 *    chost		is the FQDN of the DCC client that added the header
 *    server-ID		is the ID of the DCC server providing the counts
 *    cknm1, cknm2, ...	are names of checksums
 *    cnt1, cnt2, ...	are counts or special counts
 */
#define DCC_XHDR_START	"X-DCC-"

#define DCC_XHDR_BULK		"bulk"
#define DCC_XHDR_BULK_REP	"bulk rep"

/* names of checksums */
#define DCC_XHDR_TYPE_IP	    "IP"	    /* binary source IP addr */
#define DCC_XHDR_TYPE_ENV_FROM	    "env_From"	    /* envelope Mail From */
#define DCC_XHDR_TYPE_FROM	    "From"	    /* header line */
#define DCC_XHDR_TYPE_SUB	    "substitute"    /* random header line */
#define DCC_XHDR_TYPE_MESSAGE_ID    "Message-ID"    /* header line */
#define DCC_XHDR_TYPE_RECEIVED	    "Received"	    /* last header line */
#define DCC_XHDR_TYPE_BODY	    "Body"	    /* body */
#define DCC_XHDR_TYPE_FUZ1	    "Fuz1"	    /* filtered body */
#define DCC_XHDR_TYPE_FUZ2	    "Fuz2"	    /*   "       "   */
#define DCC_XHDR_TYPE_GREY_MSG	    "Grey_Msg"	    /* greylist msg checksum */
#define DCC_XHDR_TYPE_GREY_TRIPLE   "Grey3"	    /* greylist triple cksum */
#define DCC_XHDR_TYPE_REP_TOTAL	    "rep-total"
#define DCC_XHDR_TYPE_REP_BULK	    "rep"
#define DCC_XHDR_TYPE_SRVR_ID	    "server-ID"	    /* check dup. server-ID */
#define DCC_XHDR_TYPE_ENV_TO	    "env_To"	    /* envelope Rcpt To */
#define DCC_XHDR_TYPE_FLOD_PATH	    "flood path"
#define DCC_XHDR_MAX_TYPE_LEN  (ISZ("unknown xxx"))


/* strings used in X-DCC counts */
#define DCC_XHDR_TOO_MANY	"many"	    /* too many targets to number */
#define DCC_XHDR_GREY_PASS	"pass"	    /* embargo has ended */
#define DCC_XHDR_OK		"ok"	    /* certified not spam */
#define DCC_XHDR_OK2		"ok2"	    /* half certified not spam */
#define DCC_XHDR_OK_MX		"mx"	    /* semi-trusted MX server */
#define DCC_XHDR_OK_MXDCC	"mxdcc"	    /* semi-trusted MX server w/DCC */
#define DCC_XHDR_DEL		"del-req"   /* delete request */
#define DCC_XHDR_TGTS_REP_ADJ	"rep-adj"   /* adjust reputation total */
#define DCC_XHDR_INVALID	"-"
#define DCC_XHDR_MAX_TGTS_LEN	12

/* special server-IDs */
#define DCC_XHDR_ID_INVALID	"invalid"	/* DCC_ID_INVALID */
#define DCC_XHDR_ID_ANON	"anon"		/* DCC_ID_ANON */
#define DCC_XHDR_ID_WHITE	"whitelist"	/* DCC_ID_WHITE */
#define DCC_XHDR_ID_COMP	"compressed"	/* DCC_ID_COMP */
#define DCC_XHDR_ID_DELETED	"deleted"	/* DCC_ID_DELETED */

#define	DCC_XHDR_REJ_DATA_MSG	"rejection message: "
#define DCC_XHDR_RESULT		"result: "
#define DCC_XHDR_RESULT_I_A	"ignore and accept"
#define	DCC_XHDR_RESULT_A_GREY	"after greylist embargo"
#define	DCC_XHDR_RESULT_DISCARD	"discard"
#define	DCC_XHDR_RESULT_ACCEPT	"accept"
#define	DCC_XHDR_RESULT_REJECT	"reject"
#define DCC_XHDR_RESULT_DCC_FAIL "DCC failure"
#define	DCC_XHDR_REJ_RCPT_MSG	DCC_XHDR_REJ_DATA_MSG
#define DCC_XHDR_RESULT_RCPT_REJECT "reject temporarily"
#define DCC_XHDR_INCOMPAT_WLIST	"incompatible whitelists"
#define DCC_XHDR_TOO_MANY_RCPTS	"too many recipients"

#define DCC_XHDR_ISOK		"-->OK"
#define DCC_XHDR_ISSPAM		"-->spam"

/* greylist embargo results that are recognized by other programs */
#define DCC_XHDR_GREY_RECIP	"greylist recipient"
#define DCC_XHDR_EMBARGO_FAIL	"Sys Failure"
#define DCC_XHDR_EMBARGO_ENDED	"Embargo Ended"
#define DCC_XHDR_EMBARGO	"Embargo"
#define DCC_XHDR_EMBARGO_NUM	"Embargo #%d"
#define DCC_XHDR_EMBARGO_PASS	"Pass"
#define DCC_XHDR_EMBARGO_OK	"Recognized OK"
#define DCC_XHDR_EMBARGO_REST	"Embargo #%d reset"

#endif /* DCC_XHDR_H	*/
