/* Distributed Checksum Clearinghouse
 *
 * sample external filter
 *
 * Rhyolite Software DCC 1.3.42-1.5 $Revision$
 *
 * To use this toy, rebuild the DCC client code with something like
 *	/var/dcc/libexec/updatedcc -c--with-xfltr=xfltr_sample.c
 *
 * Add something like the following to DCCM_ARGS or DCCIFD_ARGS in
 *  /var/dcc/dcc_conf:
 *	-X "parm=whatever"
 *
 *  This or a real external filter interface such as rpd.c should be installed
 *	in the thrlib directory	and built into the DCC clients with
 *	    ./configure --with-xfltr=xfltr_sample.c
 *	or
 *	    /var/dcc/libexec/updatedcc -c--with-xfltr=xfltr_sample.c
 *
 * Like all external filters for DCC clients, this file has the following:
 *	xfltr_parm		run time parameter
 *	xfltr_threads		number of threads/process
 *	xfltr_debug		debugging message level (external)
 *	xfltr_open()		get process ready
 *	xfltr_thread_start()	when a thread starts
 *	xfltr_work()		check a message using the following:
 *		req->hdr.id	    queue or message-ID
 *		req->targets	    number of recipients
 *		req->helo	    SMTP HELO value
 *		req->sender_name    reverse DNS name of mail sender
 *		req->sender_addr    IPv6 address of mail sender
 *		req->env_from	    envelope Mail_From value
 *	xfltr_thread_stop()	when a thread shuts down
 *	dcc_xfltr_close()	clean up for process
 */

#include "helper.h"

int xfltr_threads = 20;
const char *xfltr_parm;

/* there must be at least one reference to this variable to make
 * the kludge of stub linking work */
extern int xfltr_debug;


/* when first starting */
u_char
xfltr_open(void)
{
	return 1;
}



/* as thae last thread ends */
void
xfltr_close(void)
{
}



u_char
xfltr_thread_start(void)
{
	return 1;
}



void
xfltr_thread_stop(void)
{
}



/* deal with one mail message */
u_char					/* 1=send response to other thread */
xfltr_work(const XFLTR_REQ *req,
	   XFLTR_RESP *resp)
{
	int fd;
	char buf[1024];
	int len, i;

	if (xfltr_debug > 4)
		dcc_trace_msg("%s sample filter starting on %s",
			      req->hdr.id, req->tmp_nm);

	fd = open(req->tmp_nm, O_RDONLY, 0);
	if (fd < 0) {
		dcc_error_msg("%s sample filter open(%s): %s",
			      req->hdr.id, req->tmp_nm, ERROR_STR());
		return 1;
	}

	/* reject it if the HELO value or the sender matches the
	 *	xfltr_parm or -Xparm=value
	 * and there is a 0x01 (control-A) character somewhere in the
	 * message */
	if (!strcasecmp(xfltr_parm, req->helo)
	    || !strcasecmp(xfltr_parm, req->env_from)) {
		for (;;) {
			len = read(fd, buf, sizeof(buf));
			if (len <= 0) {
				if (len < 0)
					dcc_error_msg("%s read(%s): %s",
						      req->hdr.id, req->tmp_nm,
						      ERROR_STR());
				break;
			}
			for (i = 0; i < len; ++i) {
				if (buf[i] == '\01') {
					resp->reject = 1;
					goto out;
				}
			}
		}
out:;
	}

	i = snprintf(resp->header, sizeof(resp->header),
		     "X-sample-test: %s %s\n",
		     req->hdr.id, resp->reject ? "rejected" : "ok");
	if (i >= ISZ(resp->header))
		resp->header_len = sizeof(resp->header)-1;
	else
		resp->header_len = i;

	close(fd);
	return 1;
}
