/* Distributed Checksum Clearinghouse
 *
 * threaded functions for sending messages through external filter
 *
 * Copyright (c) 2005 by Rhyolite Software, LLC
 *
 * This agreement is not applicable to any entity which sells anti-spam
 * solutions to others or provides an anti-spam solution as part of a
 * security solution sold to other entities, or to a private network
 * which employs the DCC or uses data provided by operation of the DCC
 * but does not provide corresponding data to other users.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * Parties not eligible to receive a license under this agreement can
 * obtain a commercial license to use DCC and permission to use
 * U.S. Patent 6,330,590 by contacting Commtouch at http://www.commtouch.com/
 * or by email to nospam@commtouch.com.
 *
 * A commercial license would be for Distributed Checksum and Reputation
 * Clearinghouse software.  That software includes additional features.  This
 * free license for Distributed ChecksumClearinghouse Software does not in any
 * way grant permision to use Distributed Checksum and Reputation Clearinghouse
 * software
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND RHYOLITE SOFTWARE, LLC DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL RHYOLITE SOFTWARE, LLC
 * BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 * Rhyolite Software DCC 1.3.42-1.10 $Revision$
 */

int xfltr_debug;


#include "helper.h"
#ifdef USE_XFLTR
#ifdef HAVE_PTHREAD_H
#include <pthread.h>
#else
#include <sys/pthread.h>
#endif



u_char
xfltr_new_thread(u_char first_thread)
{
	if (first_thread) {
		if (!xfltr_parm)
			dcc_logbad(EX_SOFTWARE, "xfltr_parm is null");
		if (!xfltr_open())
			return 0;
	}
	return xfltr_thread_start();
}


void NRATTRIB
xfltr_old_thread(u_char last_thread)
{
	xfltr_thread_stop();
	if (!last_thread)
		pthread_exit(0);
	xfltr_close();
	exit(0);
}



u_char
xfltr_thread_create(const char *type_str, void *arg)
{
	pthread_t tid;
	int i;

	i = pthread_create(&tid, 0, helper_thread, arg);
	if (i) {
		dcc_error_msg("%s helper pthread_create(): %s",
			      type_str, ERROR_STR1(i));
		return 0;
	}

	i = pthread_detach(tid);
	if (i != 0) {
		if (i != ESRCH)
			dcc_error_msg("%s helper pthread_detach(%d): %s",
				      type_str, (int)tid, ERROR_STR1(i));
		else if (xfltr_debug)
			dcc_trace_msg("%s helper pthread_detach(%d): %s",
				      type_str, (int)tid, ERROR_STR1(i));
	}
	return 1;
}

#endif /* USE_XFLTR */
