%define version 0.4.5
%define initdir %(for i in /etc/init.d/ /etc/rc.d/init.d/; do if [ -d $i ]; then ( cd $i; /bin/pwd ); break; fi; done)
%define MKversion	%(echo `rpm -q mandrake-release 2>/dev/null | awk -F"-" {'print $3'}`)
%define distro uknw
%define os_version %(echo "")
%if "%MKversion"
	%define distro mk
	%define os_version %{MKversion}
%else
	%define RHversion	%(echo `rpm -q redhat-release  2>/dev/null | awk -F"-" {'print $3'}`)
	%if "%RHversion"
		%define distro rh
		%define os_version %{RHversion}
	%endif
%endif
Name: dchub
Summary: Hub software for Direct Connect.
Version: %{version}
Release: 1
License: GPL
Group: Applications/Internet
Source: %{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/build-root-%{name}
Packager: Yves BLUSSEAU <acsq2ho02@sneakemail.com>
Provides: dchub
Provides: perl(dchub_perl_functions.pl)
Prefix: /usr
Url: http://savannah.nongnu.org/projects/dchub/

BuildRequires: openssl-devel, mysql-devel, glib2-devel, automake >= 1.4
Requires(pre,preun): shadow-utils
Requires(post,preun): chkconfig
Requires: %{initdir}
Requires: perl >= 5.6, openssl >= 0.9.6b, glib2, perl-Locale-gettext >= 1.01

%if "%{distro}" == "rh"
	%if "%{RHversion}" >= "8"
BuildRequires: glibc-devel >= 2.3.2
Requires: glibc >= 2.3.2
	%endif
%else
BuildRequires: glibc-devel >= 2.2
Requires: glibc >= 2.2
%endif

%description
dchub is a DC hub clone software for Direct Connect file sharing network.

%prep
rm -rf $RPM_BUILD_ROOT 
mkdir $RPM_BUILD_ROOT

%setup -q

%build
export CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS"
%configure
make -j 2

%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}/%{initdir}
mkdir -p ${RPM_BUILD_ROOT}/var/db/dchub
mkdir -p ${RPM_BUILD_ROOT}/etc/dchub

make DESTDIR=$RPM_BUILD_ROOT mandir=%{_mandir} install-strip
install -c -m 755 dchub.init $RPM_BUILD_ROOT/%{initdir}/dchub

%pre
/usr/sbin/useradd -c "DcHub" -d /var/db/dchub \
	-s /sbin/nologin -M dchub 2>/dev/null || :

%post
/sbin/chkconfig --add dchub

%preun
if [ $1 = 0 ]; then
   /usr/sbin/userdel dchub 2>/dev/null || :
   /usr/sbin/groupdel dchub 2>/dev/null || :
   /sbin/chkconfig --del dchub
   [ -f /var/lock/subsys/dchub ] && %{initdir}/dchub stop >/dev/null 2>&1
   rmdir /usr/libexec/dchub >/dev/null 2>&1
fi
exit 0

%postun
if [ "$1" -ge 1 ]; then
	%{initdir}/dchub condrestart >/dev/null 2>&1 || :
fi


%clean
rm -rf ${RPM_BUILD_ROOT} ${RPM_BUILD_DIR}/%{name}-%{version}

%files
%doc NEWS README AUTHORS ChangeLog TODO Documentation
%defattr(-,root,root,0755)
%config %{initdir}/dchub
%{_bindir}
%defattr(-,dchub,dchub,0755)
%{_libexecdir}/dchub/extprog
%config(noreplace) %{_libexecdir}/dchub/extprog/AUTOSTART
%defattr(-,dchub,dchub)
%{_libexecdir}/dchub/scripts
%config(noreplace) %{_libexecdir}/dchub/scripts/dchub_scripts.conf
%config(noreplace) %{_libexecdir}/dchub/plugins

%attr(-,dchub,dchub) %dir /var/db/dchub
%attr(-,dchub,dchub) %dir /etc/dchub
