/* DCHub - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * ulist.h: Copyright (C) Dirk Rieger
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: ulist.h,v 1.4 2003/05/06 16:57:16 ericprev Exp $
*/

#ifndef __ULIST_H__
#define __ULIST_H__

extern GPtrArray *hub_user_list;
extern GPtrArray *hub_op_list;
extern GPtrArray *hub_user_xtra_info;
extern GPtrArray *hub_user_uinfo;

G_LOCK_EXTERN(hub_user_list);

typedef enum
{
   UNDEFINED=0,
   ACTIVE,
   PASSIVE
} UCNX;

typedef struct
{
   UCNX type;                  /* what type of connection the remote user has */
   GString *addr;                 /* address of the remote user (NULL for UNDEFINED and PASSIVE, !=NULL for ACTIVE) */
   GString *client;
   double version;
   GString *versionadd;
   GString *locka;
   GString *lockb;
   GString *lockc;
   GString *pka;
   GString *pkb;
   GString *pkc;
   int has_bzlist;
   int got_lock;
   int got_myinfo;
	char *utype;
   int need_scan;
   int warnmsg_send;
	int exceed_limit;
	unsigned long long amount;
   GString *d_client;
   double d_version;
   GString *d_versionadd;
   time_t lock_time;
   time_t last_call;
} XTRA_INFO;

/********************************/
/* free 1 user xtra information */
/********************************/
void free_xtra_info(XTRA_INFO *xi);

/*********************************/
/* empty the hub_user_list array */
/*********************************/
void reset_hub_user_list(void);

/*******************************************/
/* add the given nick to the hub user list */
/*******************************************/
void add_user_to_user_list(const char *nick);

/*****************************************/
/* add the given nick to the hub op list */
/*****************************************/
int add_user_to_op_list(const char *nick);

/*****************************************/
/* add the given nick to the [C@fe] list */
/*****************************************/
void add_user_to_cafe_list(const char *nick);

/**********************************************/
/* remove the given nick to the hub user list */
/**********************************************/
int remove_user_to_user_list(const char *nick);

/*******************************/
/* creating the users cnx data */
/*******************************/
XTRA_INFO *create_user_cnx_info(int type, const char *addr, const char *client, double version, const char *versionadd, const char *lock, const char *pk, int has_bzlist, int got_lock, int got_myinfo, const char *d_client,double  d_version, const char *d_versionadd, time_t lock_time, char *utype, int exceed_limit, unsigned long long amount);

/*******************************/
/* updating the users cnx data */
/*******************************/
int update_user_cnx_info(int i, int type, const char *addr, const char *client, double version, const char *versionadd, const char *lock, const char *pk, int has_bzlist, int got_lock, int got_myinfo, const char *d_client,double  d_version, const char *d_versionadd, time_t lock_time, char *utype, XTRA_INFO *xi, int exceed_limit, unsigned long long amount);

#endif
