# This module relays events to other python modules
# depending on the received event.
# Upon receiving an event the method 'dchub_python_handler' is
# called. This is hardcoded in the server and cannot be changed
# unless the source is modified.
# Filename: main.py
# Date: 07.07.2002
# Author: Ralph Zitz (ralph@zitz.dk)

# Importing modules (Always import dchub for the builtin functions)
import dchub
from types import *
from string import *
from os import *
from sys import *
import urllib

DchubScripts = None
IMDB_Bot     = None

##########################################################################################
# The DchubScripts class contains our standard event handling

class _DchubScripts:

   # myinfo handler
   def myinfo( self, Info ):
      global IMDB_Bot
      username = Info['nickname']
      argc     = Info['argc']

      if argc != 1:
         dchub.disconnect( username )

      userinfo = dchub.nickinfo( username )
      duration = dchub.nick_duration( username )
      minimum_share = dchub.db_get('MIN_SHARE')

      if minimum_share != None:
         return None
      if duration < 4:
         dchub.send_to_named_user( username,
                                   "<Hub-Security> This hub does not have a "
                                   "minimum share requirement. Feel free to "
                                   "share what you want.|")
         IMDB_Bot.addUser( username )

###########################################################################################
# The IMDB-Bot (Internet Movie Database)
# This bot will respond to users requesting information
# about a particular movie

class _IMDB_Bot:

   def __init__( self ):
      self.userList = []
      self.sSearchMsg = "Searching IMDB for titles starting with '$title'..."
      self.sFoundMsg = "I found the following titles, doubleclick the URL to view."
      self.sNoFoundMsg = "Sorry, nothing found."
      self.sTipMsg = "(try placing articles like The/A/An/El/Los at the end for more hits)"
      self.sWelcomeMsg = "Hi there!  If you need information about a movie, just "\
                         "send me a message containing the title of that movie."
      self.sHelloMsg = "Hi again!  What movie do you want me to find for you?"
      self.sSearchURL = "http://us.imdb.com/Tfuzzy?type=regexp&tv=off&sort=chrono&title=^"
      self.sIMDBURL = "http://us.imdb.org/Title?"

   def addUser( self, user ):
      if not self.userKnown( user ):
         self.userList.append( user )
         self.sendMsg( user, self.sWelcomeMsg )
         return 1
      else:
         self.sendMsg( user, self.sHelloMsg )
         return 0

   def removeUser( self, user ):
      if self.userKnown( user ):
         self.userList.remove( user )
         return 1
      else:
         return 0

   def userKnown( self, user ):
      return self.userList.count( user ) != 0

   def sendMsg( self, user, msg ):
      dchub.send_pchat_msg( 'IMDB-Bot', user, msg )

   def decodeMsg( self, user, msg ):
      msg = replace( msg, '<' + user + '> ', '' )
      msg = msg[:len(msg)-1]
      notify = replace( self.sSearchMsg, '$title', msg )
      self.sendMsg( user, notify )
      queryResult = self.htmlRequest( msg )
      self.sendMsg( user, queryResult )

   def htmlRequest( self, title ):
      URL = urllib.urlopen( self.sSearchURL + urllib.quote_plus( title ) )
      HTML = URL.readlines()
      URL.close()
      try:
         Start = filter( lambda x: x[:4] == '<OL>', HTML )[0]
         End   = filter( lambda x: x[:5] == '</OL>', HTML )[0]
         HTML = HTML[HTML.index(Start):]
         HTML = HTML[:HTML.index(End)]
         HTML = filter( lambda x: x[0] != '\n' and x != '</LI>\n', HTML )
         HTML = map( lambda y: replace( y, '<LI><A HREF="/Title?', '' ),
                     map( lambda x: replace( x, '<OL>', '' ), HTML )
                   )

         result = self.sFoundMsg + '\r\n'
         for i in range( len( HTML ) ):
            tmp = split( HTML[ i ], '">' )
            # filter junk
            tmp = filter( lambda x: x[:2] != '<B', tmp )
            if len( tmp ):
               title = tmp[1][:tmp[1].index('</A')]
               result = result + "  [ " + self.sIMDBURL + tmp[0] + " ] - " + title + '\r\n'
         return result
      except IndexError:
         return self.sNoFoundMsg

#############################################################################
# The main handler for Python scripting

def dchub_python_handler( Event ):

   global IMDB_Bot
   global DchubScripts

   # Create the scripts if necessary
   if type( DchubScripts ) is not InstanceType:
      DchubScripts = _DchubScripts()

   # Create the IMDB bot if necessary
   if type( IMDB_Bot ) is not InstanceType:
      IMDB_Bot = _IMDB_Bot()

   # Special case if we receive the IMDB-Bot event
   # Note: This only works for my hacked version of the dchub
   #       where a 'bot' like Hub-Security has been hardcoded
   if Event['event'] == 'IMDB-Bot':
      IMDB_Bot.decodeMsg( Event['nickname'], Event['1'] )
   # Relay events to functions if they are defined
   Function = 'DchubScripts.' + Event['event'] + '( Event )'
   try:
      eval( Function )
   except:
      return None
