#!/bin/sh

i18n_dir="../i18n"

if [ ! -d "$i18n_dir" ];then
	mkdir $i18n_dir
fi
for file in ??.po; do
	echo -n "$file: "
	lang=`echo $file | sed 's/.po$//'`
	dir="$i18n_dir/$lang/LC_MESSAGES"
	if [ ! -d "$dir" ];then
		mkdir -p $dir
	fi
	msgfmt -v --statistics $file -o $dir/dchub_handlers.mo
done
touch $i18n_dir
