#! /usr/bin/perl

# $Id: simple_globalchat_handler.pl,v 1.5 2003/05/12 13:06:55 blusseau Exp $

use strict;

our $RULES; # load from simple_myinfo_handler

add_hook ("globalchat",\&simple_globalchat_handler);

# -rules command
add_help_description("-rules",_("Show the Hub rules"));
# -call command
add_help_description("-call",_("Sends a private message to NICK telling him to check the mainchat"));
add_help_usage("-call","-call NICK");
# +seen command
add_help_description("+seen",_("Show when a user entered or left the hub"));
add_help_usage("+seen","+seen NICK");
# +msg command
add_help_description("+msg",_("Post a message to NICK"));
add_help_usage("+msg","+msg  NICK MSG");
# -dis command
add_help_description("-dis",_("Disconnect NICK"),'O');
add_help_usage("-dis","-dis  NICK",'O');
# -kick command
add_help_description("-kick",_("Kick NICK"),'O');
add_help_usage("-kick","-kick NICK",'O');

sub simple_globalchat_handler {

	my (undef,$nick,$mess) = @_; # evt_array not needed

	if ($mess=~ /^-rules/i) {
		if ($RULES) {
			dchub::send_pchat_msg("Hub", $nick, "$RULES|");
		} else {
			dchub::send_pchat_msg("Hub", $nick, _("No rules defined"));
		}
	} elsif ($mess=~ /^-call/i) {
		my @name=split(/\s/, $mess);
		my $nick_to_call=$name[1];
		if ($nick_to_call) {
			dchub::send_pchat_msg("Hub-Security", $nick, _("Calling")." $nick_to_call.|");	
			dchub::send_pchat_msg("Hub-Security", $nick_to_call,"$nick "._("is calling for you in the main chat").". |");
		} else {
			dchub::send_to_named_user($nick,"<Hub-Security> ".sprintf(_("Invalid parameters for %s command."),"-call")."|");
			dchub::send_to_named_user($nick,"<Hub-Security> Usage: -call USERNAME|");
		}
	} elsif ($mess=~ /^-dis/i) {
		my @name=split(/\s/, $mess);
		my $nick_to_disconnect=$name[1];
		if ($nick_to_disconnect) {
			if ((dchub::nick_type($nick) eq "O") || (dchub::nick_type($nick) eq "M")
				|| (dchub::nick_type($nick) eq "F")) {
				dchub::send_to_all_users("<Hub-Security> "._("Disconnecting")." $nick_to_disconnect. |");
				dchub::disconnect($nick_to_disconnect);
			} else {
				dchub::send_to_named_user($nick,"<Hub-Security> "._("You don't have the right to use this command")."|");
			}
		} else {
			dchub::send_to_named_user($nick,"<Hub-Security> ".sprintf(_("Invalid parameters for %s command."),"-dis")."|");
			dchub::send_to_named_user($nick,"<Hub-Security> Usage: -dis USERNAME|");
		}
	} elsif ($mess=~ /^-kick/i) {
		if ((dchub::nick_type($nick) eq "O") || (dchub::nick_type($nick) eq "M")) {
			dchub::hubcmd($nick,"$mess|");
		} else {
			dchub::send_to_all_users("<Hub-Security> "._("Disconnecting")." $nick "._("for trying to use an operator command")."|");
			dchub::disconnect($nick);
		}
	}
}
print "Perl: simple_globalchat_handler "._("module loaded").".\n";
