/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * afk_list.c: Copyright (C) Dirk Rieger
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: afk_list.c,v 2.3 2003/03/07 16:02:41 ericprev Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <errno.h>
#include <glib.h>

#include "config.h"
#include "tos_key.h"
#include "afk_list.h"
#include "user_cnx_lst.h"
#include "gvar.h"
#include "global_user_if.h"

typedef struct
{
	GString* afk_nick;
	GString* afk_message;
	time_t afk_time;
} AFK_ENTRY;

/**********************/
/* arry of AFK_ENTRY */
/**********************/
static GArray *afk_array=NULL;

G_LOCK_DEFINE_STATIC(afk_array);

void add_afk_msg(LOCAL_USER_CNX_ENTRY *luce,GString **dest_base,const GString *afk_msg)
{
	AFK_ENTRY nw;
	GString *afk_reply;
	G_LOCK(afk_array);

	if(afk_array!=NULL)
		find_afk_by_nickname_uniq(luce->user_nick->str);	/* remove old entry... */

	/* initialise new entry */
	nw.afk_nick=g_string_new(luce->user_nick->str);
	nw.afk_message=g_string_new(afk_msg->str);
	time(&nw.afk_time);

#if 0
	printf("add afk-message from %s: %s\n",luce->user_nick->str,afk_msg->str);
#endif

	if(afk_array==NULL)
		afk_array=g_array_new(FALSE,FALSE,sizeof(AFK_ENTRY)); /* creating Array */

	/* Eintrag anhngen */
	afk_array=g_array_append_val(afk_array,nw);
	G_UNLOCK(afk_array);

#if 0
	printf("adding afk-message from %s done\n",luce->user_nick->str);
#endif

	afk_reply=g_string_new("");
	g_string_sprintfa((*dest_base),"Your afk/away - Message was successfully saved!!!\r\n- cu later %s\r\n\r\n... Please don't forget to tell me when you're back, Command: '+back' !|",luce->user_nick->str);
	send_const_str_to_luce(luce,(*dest_base)->str);

	if((luce->privilege==TYPE_O_PRIV)||(luce->privilege==TYPE_M_PRIV))
	{
		GString *afk_reply;
		afk_reply=g_string_new("");
		g_string_sprintf(afk_reply,"<Info> the operator %s is 'afk' - away from keyboard|",luce->user_nick->str);
		GLUS_SEND_TO_EVERYONE(afk_reply);		/* don't free afk_reply */
	}
}

void find_afk_by_nickname(const char *pm_dest, const char *pm_sender)
{
	int i;

	G_LOCK(afk_array);
	if(afk_array!=NULL)
	{
		for(i=0;i<afk_array->len;i++)
		{
			AFK_ENTRY *nw;
			nw=&(g_array_index(afk_array,AFK_ENTRY,i));
			if(strcmp(nw->afk_nick->str,pm_dest) == 0)
			{
				GString *dest;
				dest=g_string_new("");
				g_string_sprintf(dest,"$To: %s From: %s $<Info> the user %s is afk (away from keyboard)!\r\nMessage: %s|",pm_sender,pm_dest,pm_dest,nw->afk_message->str);
				GLUS_SEND_TO_A_NICK(pm_sender,dest);			/* don't free dest */
				break;
			}
         else if(strcmp(nw->afk_nick->str,pm_sender)==0)
         {
            GString *dest;
            dest=g_string_new("");
            g_string_sprintf(dest,"$To: %s From: %s $<Info> ATTENTION - please delete your afk-message !!!|",pm_sender,pm_dest);
				GLUS_SEND_TO_A_NICK(pm_sender,dest);
				break;
         }
		}
	}
	G_UNLOCK(afk_array);
}

static inline void delete_afk_entry(int num)
{
	/* Attention: this function is "unsafe", */
	/* the afk_array has to be locked before !!! */
	AFK_ENTRY *ad;

	ad=&(g_array_index(afk_array,AFK_ENTRY,num));
	if(ad->afk_nick)
		g_string_free(ad->afk_nick,TRUE);
	if(ad->afk_message)
		g_string_free(ad->afk_message,TRUE);

	afk_array=g_array_remove_index_fast(afk_array,num);
}

void find_afk_by_nickname_uniq(const char *nickname)
{
	time_t t;
	struct tm *stime;
	int i;
	if(afk_array!=NULL)
	{
		for(i=0;i<afk_array->len;i++)
		{
			AFK_ENTRY *nw;
			nw=&(g_array_index(afk_array,AFK_ENTRY,i));
			if(!strcmp(nw->afk_nick->str,nickname))
			{
				t=nw->afk_time;
				stime=localtime(&t);
				printf("Found: %s %s -> deleting entry\n",nw->afk_nick->str,asctime(stime));
				delete_afk_entry(i);
				break;
			}
		}
	}
}

void del_afk_on_quit(const char *evt_name, const char *evt_emitter, int nb_args, va_list ap, char *xtra_param)
{
	G_LOCK(afk_array);
	if(afk_array!=NULL)
		find_afk_by_nickname_uniq(evt_emitter);
	G_UNLOCK(afk_array);
}

void del_afk_entry(LOCAL_USER_CNX_ENTRY *luce,GString **dest_base)
{
	G_LOCK(afk_array);
	if(afk_array!=NULL)
	{
		int i;
		for(i=0;i<afk_array->len;i++)
		{
			AFK_ENTRY *nw;
			nw=&(g_array_index(afk_array,AFK_ENTRY,i));
			if(!strcmp(nw->afk_nick->str,luce->user_nick->str))
			{
				delete_afk_entry(i);

				g_string_sprintfa((*dest_base),"Your afk/away - message was removed successfully!\r\n- Welcome back %s|",luce->user_nick->str);
				send_const_str_to_luce(luce,(*dest_base)->str);

				if((luce->privilege==TYPE_O_PRIV)||(luce->privilege==TYPE_M_PRIV))
				{
					GString *back_msg;
					back_msg=g_string_new("");
					g_string_sprintf(back_msg,"<Info> the operator %s is back at the keys|",luce->user_nick->str);
					GLUS_SEND_TO_EVERYONE(back_msg);	/* don't free back_msg */
				}
				break;
			}
		}
	}
	G_UNLOCK(afk_array);
}

/******************************************/
/* scan tos array to find expired entries */
/******************************************/
void timeout_afk(void)
{
	time_t now;

	G_LOCK(afk_array);

	now=time(NULL);
	if(afk_array!=NULL)
	{
		int i;

		for(i=afk_array->len-1;i>=0;i--)
		{
			AFK_ENTRY *te;

			te=&(g_array_index(afk_array,AFK_ENTRY,i));

			/* remove afk-messages after 24h */
			if(te->afk_time<=(now-(3600*24)))
			{
				delete_afk_entry(i);
			}
		}
	}
	G_UNLOCK(afk_array);
}

