/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * bin_xf_io.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: bin_xf_io.h,v 2.3 2003/02/09 17:56:09 eric Exp $
*/

#ifndef __BIN_XF_IO_H__
#define __BIN_XF_IO_H__

#include <netinet/in.h>
#include "cnx_if_detect.h"
#include "ged_if.h"
#include "chunk.h"

#define MAX_BIN_SIZE (128*1024)

#include "common_defines.h"

/*********************************************/
/* structure defining the IO of a connection */
/*********************************************/
typedef struct
{
	/* const values */
	int sock_fd;					/* the socket descriptor */
	time_t start_time;			/* creation time of this entry */
   struct in_addr user_ip;		/* user ip */
	CNX_IF_TYPE if_type;       /* type of the network interface this connection uses to go out */
	
	/* variable values */
	
	GList *incoming_chunks;  	/* glist of CHUNK_CORE */
   GByteArray *in_partial;		/* partially received chunk */
   GList *outgoing_chunks;		/* glist of GByteArray (planar version of CHUNK_CORE *) */

	CLOSE_STATUS closed;			/* socket status */

	/* counters */
	guint64 in_data;				/* downloaded bytes */
	guint64 out_data;				/* uploaded bytes */
} BIN_XF_IO;

/* ------------------------------------------------------------------------------------ */
/* --------------------- XF_IO creation/destruction functions ------------------------- */
/* ------------------------------------------------------------------------------------ */
/*********************************************************************************************/
/* create a new BIN_XF_IO. The BIN_XF_IO entry is automatically registered in the IO handler */
/*********************************************************************************************/
/* if remote_addr ==NULL, the function computes it */
/***************************************************/
BIN_XF_IO *create_bin_xfio(int sock_fd, struct in_addr *remote_addr);

/*********************************************************************************************/
/* delete a BIN_XF_IO. The BIN_XF_IO entry is automatically unregistered from the IO handler */
/* and the socket is closed.                                                                 */
/*********************************************************************************************/
void delete_bin_xfio(BIN_XF_IO *to_del);

/* ------------------------------------------------------------------------------------ */
/* --------------------------- XF_IO incoming functions ------------------------------- */
/* ------------------------------------------------------------------------------------ */
/************************************************************/
/* same as peek_first_string_of_glist except the GString is */
/* also removed from the GList. You must free it yourself   */
/* when you don't need it anymore.                          */
/************************************************************/
/* output: the pointer or NULL */
/*******************************/
CHUNK_CORE *bin_xfio_take_first_chunk_of_glist_incoming(BIN_XF_IO *xfio);

/* ------------------------------------------------------------------------------------ */
/* --------------------------- XF_IO outgoing functions ------------------------------- */
/* ------------------------------------------------------------------------------------ */
/**************************************************************/
/* append a (copy of the given) GByteArray to the given glist */
/*****************************************************************************/
/* if do_copy==TRUE, a copy is created and used                              */
/* if do_copy==FALSE, the given GByteArray is used and must not be destroyed */
/*****************************************************************************/
void bin_xfio_append_new_gba_to_glist_outgoing(BIN_XF_IO *bxfio, GByteArray *gba, int do_copy);

/* ------------------------------------------------------------------------------------ */
/* ----------------------------- XF_IO misc functions --------------------------------- */
/* ------------------------------------------------------------------------------------ */
/************************/
/* return I/O statistic */
/************************/
void bin_xfio_get_io_stats(guint64 *incoming_bytes, guint64 *outgoing_bytes);

/* ------------------------------------------------------------------------------------ */
/* ----------------------------- XF_IO misc test macros ------------------------------- */
/* ------------------------------------------------------------------------------------ */
#define BIN_XFIO_IS_CLOSED(xfio)		(xfio->closed==CNX_CLOSED)
#define BIN_XFIO_INPUT_AVAILABLE(xfio)	(xfio->incoming_chunks!=NULL)

/* ------------------------------------------------------------------------------------ */
/* ------------------------- GED initialization function ------------------------------ */
/* ------------------------------------------------------------------------------------ */
/************************************************************/
/* function initializing the handler of all the connections */
/************************************************************/
GED_CALLBACKS *bin_xf_io_handler_init(void);

#endif
