/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * chunk_codes.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: chunk_codes.h,v 2.11 2003/02/27 14:55:30 ericprev Exp $
*/

#ifndef __CHUNK_CODES_H__
#define __CHUNK_CODES_H__

#include "common_defines.h"

/* length of a hub ID (it must be the same value as MD_BLOC_SIZE) */
#define HUB_ID_LEN MD_BLOC_SIZE

/******************************/
/* routing using HUB_CNX_TYPE:
   source         -         destination
   local hub      ->        local_hub, HC_TYPE_1 and HC_TYPE_3
   HC_TYPE_1      ->        local_hub and HC_TYPE_3
   HC_TYPE_3      ->        local_hub and HC_TYPE_1
 */
/******************************/
typedef enum
{
	HC_TYPE_1=1,      /* fully connected cluster hub */
	HC_TYPE_3=3,      /* 1-way connected cluster hub */
} HUB_CNX_TYPE;

/*
	1 SVAL = in network byte order, 1 gint8 or 1 gint16 or 1 gint32
	1 UVAL = in network byte order, 1 guint8 or 1 guint16 or 1 guint32
   1 ULVAL = in network byte order, 1 guint64
   1 NNSTR = 1 not '\0' terminated string 
 */

/* list of all valid subchunk codes */
enum
{
	SC_HUB_ID=0,         /* hub id (value is different for all hubs). param: HUB_ID_LEN bytes */
	SC_HUB_NAME=1,       /* hub name. param: 1 NNSTR */
	SC_HUB_CNX_TYPE=2,   /* type of connection to the hub. param: 1 UVAL w/ value from HUB_CNX_TYPE */
	SC_HUB_HOP_COST=3,   /* cost of connection usage. param: 1 UVAL > 0 */
	SC_HUB_CLUS_ID=4,    /* hub cluster id (value is identical for hub in the same cluster). param: MD_BLOC_SIZE bytes */
	SC_HUB_CHALLENGE=5,  /* hub challenge reply. param: HUB_ID_LEN bytes (==md5sum of remote SC_HUB_ID and local SC_HUB_CLUS_ID) */
	SC_HUB_VARIx=6,		/* Variable key content. param: VARIABLE_KEY_LENGTH bytes */

	SC_MSG_CONTENT=128,  /* a message (not only chat). 1 NNSTR */

	SC_USER_NICK=256,    /* a user nickname. param: 1 NNSTR */
	SC_USER_SHARE=257,   /* size of the share of a user. param: 1ULVAL */
	SC_USER_MAIL=258,    /* a user e-mail address. param: 1 NNSTR */
	SC_USER_DESC=259,    /* a user description. param: 1 NNSTR */
	SC_USER_FLAG=260,    /* user flag. param: 1UVAL */
	SC_USER_EFLAG=261,   /* user ext flag. param: 1UVAL */
	SC_USER_PRIV=262,    /* user privilege. param: 1UVAL */
	SC_USER_CNX_TYPE=263,/* user connection type. param: 1NNSTR */
	SC_USER_CLIVER=264,  /* user client version. param: 1NNSTR */
	SC_USER_EDISP=265,	/* user ext display flag. param: 1 UVAL */

	SC_KICK_KICKER=384,	/* user kicking another user. param: 1NNSTR */
	SC_KICK_DURATION=385,/* kicking message. param: 1UVAL */

	SC_HUB_USERS=512,    /* number of users on the hub. param: 1 UVAL */

	SC_RETURN_PATH=1024,	/* return path for a search. Either hub:nick or ip:port. param: 1NNSTR */
	SC_FILE_CRC=1025,    /* e2dk file CRC. param: 16 guint8 */
	SC_FILE_LEN=1026,    /* length of file. param: 1UVAL */
	SC_STD_SEARCH=1027,  /* standard search pattern: a?b?c?d?eeeee (search $Search format). param: 1NNSTR */
	SC_FILE_L0CRC=1028,  /* e2dk l0 CRC. param: n*16 guint8 */
	SC_FILENAME=1029,    /* a filename. param: 1NNSTR */

	SC_TXT_ERROR=65534,  /* the (text) error code. param: 1NNSTR */
	SC_NUM_ERROR=65535,  /* the (numeric) error code. param: 1 SVAL */
};

/* list of all valid chunk codes (and descrption of their required/optionnal subchunk codes) */
enum
{
	CC_HUB_LOG_S0=0,     /* hub first login stage. Require: SC_HUB_ID, SC_HUB_VARIx */
	CC_HUB_CHALLENGE=1,  /* hub challenge (2nd login stage). Require: SC_HUB_CHALLENGE */
	CC_HUB_LOGIN=2,      /* hub final login stage. On success, contains all tags of CC_HUB_ID but SC_HUB_ID, on error: SC_NUM_ERROR */
	CC_HUB_ID=3,         /* hub identication. Require: SC_HUB_ID, SC_HUB_NAME, SC_HUB_CNX_TYPE, SC_HUB_HOP_COST */
	
	CC_USER_IN=64,       /* incoming or updating user. Require: SC_USER_NICK. Optional: SC_USER_SHARE,SC_USER_MAIL, */
	                     /* SC_USER_DESC,SC_USER_FLAG,SC_USER_EFLAG,SC_USER_PRIV,SC_USER_CNX_TYPE,SC_USER_CLIVER */
	CC_USER_OUT=65,      /* leaving user. Require: SC_USER_NICK */
	CC_USER_LST_REQ=66,	/* retrieve the list of all users connected to the remote hub (except the one from the hub sending the command) */
	CC_USER_LST=67,		/* reply of CC_USER_LST_REQ. Require: SC_HUB_USERS and same as CC_USER_IN. A SC_USER_NICK is the start of values of a new nickname */
								/* technically, the reply is an array with a variable number of element per user */
	CC_USER_INFO_REQ=68,	/* retrieve the information of a user. Require: SC_USER_NICK (reply will be a CC_USER_IN) */

	CC_USER_KICK=96,		/* kick a user out of the cluster. Require: SC_USER_NICK. Optional: SC_KICK_KICKER, SC_MSG_CONTENT, SC_KICK_DURATION */
	CC_USER_DISC=97,		/* disconnect a user of the cluster. Require: SC_USER_NICK */

	CC_BCAST=128,        /* broadcast a content. Require: SC_MSG_CONTENT */
	CC_UCAST=129,        /* send a content to a user. Require: SC_MSG_CONTENT, SC_USER_NICK */

	CC_XSEARCH=256,		/* extended search. Require: SC_RETURN_PATH, SC_FILE_CRC, SC_FILE_LEN, SC_STD_SEARCH */
	CC_MD4SET=512,			/* MD4 set. Require: SC_FILE_CRC, SC_FILE_LEN, SC_FILE_L0CRC, SC_FILENAME, SC_USER_NICK */
};

/* list of error codes */
enum
{
	ERR_INVALID_CHALLENGE_REPLY=1,
};
#endif
