/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * cnx_if_detect.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: cnx_if_detect.h,v 2.1 2003/02/16 08:00:35 eric Exp $
*/

#ifndef __CNX_IF_DETECT_H__
#define __CNX_IF_DETECT_H__

#include <netinet/in.h>

typedef enum
{
	CIT_UNKNOWN,
	CIT_STATIC,
	CIT_DYNAMIC,
} CNX_IF_TYPE;

/*************************************************************************/
/* check the KEY 'dyn_if' and retrieve the IP of these interface to keep */
/* their information accurate.                                           */
/*************************************************************************/
/* if the IP of an interface has changed, all the connections with the */
/* DYNAMIC flag set are closed (shutdown).                             */
/***********************************************************************/
void update_dynamic_if_ip(void);

/*************************************/
/* identify the type of a connection */
/*************************************/
CNX_IF_TYPE identify_if_of_cnx(int socket_fd);

/*************************************************************************/
/* check the KEY 'dyn_if' and retrieve the IP of these interface to keep */
/* their information accurate.                                           */
/*************************************************************************/
/* if the IP of an interface has changed, all the connections with the */
/* DYNAMIC flag set are closed (shutdown).                             */
/***********************************************************************/
void update_dynmic_if_ip(void);


/***************************************************/
/* retrieve the remote IP of an AF_INET connection */
/***************************************************/
void get_remote_if_ip(int sock_fd,struct in_addr *remote_ip);

#endif
