/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * global_user.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: global_user.h,v 2.12 2003/02/26 08:20:45 ericprev Exp $
*/

#ifndef __GLOBAL_USER_H__
#define __GLOBAL_USER_H__

#include "global_user_if.h"
#include "g_string_ref.h"

typedef struct
{
	/* a set of condition */
	const char *nickname;
	unsigned int uflag_msk;		/* user_flag & uflag_msk == wanted_uflag ? */
	unsigned int wanted_uflag;
	unsigned int eflag_msk;		/* ext_flag & eflag_msk == wanted_eflag ? */
	unsigned int wanted_eflag;

	/* and the message to send */
	GString_ref *msg;
} GLUS_PARAM;

typedef struct
{
	const char *glus_name;		/* it is the name of the handler [mainly for debug] */

	/**************************************************************************************/
	/* send a message to a user having the given name and required user_flag and ext_flag */
	/* zero *_msks force GLUS to ignore these flags                                       */
	/* output: 0=ok else user not found                                                   */
	/**************************************************************************************/
	int (*send_to_named_user)(GLUS_PARAM *glus_param);

	/***************************************************************************************/
	/* send a message to all users having required user_flag and ext_flag                  */
	/* zero *_msks force GLUS to ignore these flags                                        */
	/* if nickname is not NULL, the given user is ignored and will not receive the message */
	/***************************************************************************************/
	void (*send_to_all_users)(GLUS_PARAM *glus_param);

	/*********************************************/
	/* retrieve user information from a nickname */
	/*********************************************/
	GLUS_USER_INFO * (*get_user_info)(const char *nickname);

	/******************************************************/
	/* get all users. (add GLUS_USER_INFO * to the array) */
	/******************************************************/
	void (*get_users_info)(GPtrArray *array_of_gui_ptr);

	/**************************************************************************/
	/* get all users having the given IP. (add GLUS_USER_INFO * to the array) */
	/**************************************************************************/
	void (*get_users_info_by_ip)(GPtrArray *array_of_gui_ptr, struct in_addr ip);

	/************************************************************************/
	/* add the nicks to the provided strings (each nick is '$$' terminated) */
	/************************************************************************/
	/* list[0]= user nick list */
	/* list[1]= op nick list   */
	/***************************/
	void (*get_nick_lists)(GString **lists);

	/****************************************************************/
	/* add the shared size and number of users to current variables */
	/****************************************************************/
	void (*add_hub_users_stat)(guint64 *shared_size, unsigned int *nb_users);

	/******************************************/
	/* kick the user having the given name    */
	/* the user is kicked by kicking_nickname */
	/* output: 0=ok else user not found       */
	/******************************************/
	int (*kick_named_user)(const char *kicking_nickname, const char *nickname);

	/*************************************************/
	/* disconnect the user having the given nickname */
	/* output: 0=ok else user not found              */
	/*************************************************/
	int (*disconnect_named_user)(const char *nickname);

	/**************************************************************/
	/* function called after a user was disconnected from the hub */
	/* the function is not here to destroy a user itself, it is   */
	/* here to notify other I/O function this user has left       */
	/**************************************************************/
	void (*user_is_disconnected)(const char *nickname);

	/*************************************************************/
	/* the following functions are communication functions       */
	/* they just send an "event" in the format of the connection */
	/*************************************************************/
	/*****************************************************/
	/* function used to say a "$Hello" on the connection */
	/*****************************************************/
	void (*user_do_hello)(const char *nickname);

	/****************************************************/
	/* function used to say a "$Quit" on the connection */
	/****************************************************/
	void (*user_do_quit)(const char *nickname);

	/******************************************************/
	/* function used to say a "$MyINFO" on the connection */
	/******************************************************/
	void (*user_do_my_info)(const char *nickname, const char *description, const char *user_cnx_type, const unsigned int user_flag, const char *user_mail, const guint64 shared_size, const unsigned int ext_flag, const unsigned int privilege, const char *client_version);

	/****************************************************/
	/* process a $XSearch and send it on the connection */
	/****************************************************/
	void (*user_do_xsearch)(const char *return_path, const guint8 *file_crc, const guint32 file_length, const char *std_search);

	/**********************************************/
	/* function called when a $MD4Set is received */
	/***************************************************************/
	/* g_crc is the file global CRC (MD_BLOC_SIZE bytes)           */
	/* l_crc is the set of partial CRC (nb_seg*MD_BLOC_SIZE bytes) */
	/* nickname is the return path nickname                        */
	/***************************************************************/
	void (*md4set_received)(const guint8 *g_crc, const guint32 file_length, const guint8 *l_crc, const guint32 nb_seg, const char *filename, const char *nickname);
} GLOBAL_USER_CALLBACKS;

/**************************************/
/* register a new GLOBAL_USER handler */
/**************************************/
void global_user_register(GLOBAL_USER_CALLBACKS *);

#endif
