/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * hub_cnx_lst.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: hub_cnx_lst.h,v 2.7 2003/03/07 16:21:35 ericprev Exp $
*/

#ifndef __HUB_CNX_LST_H__
#define __HUB_CNX_LST_H__

#include <glib.h>
#include <time.h>
#include "hl_locks.h"
#include "cnx_if_detect.h"
#include "bin_xf_io.h"
#include "chunk_codes.h"

/************************************/
/* structure of a user of a cluster */
/************************************/
typedef struct
{
	/* DC users information */
	const char *user_cnx_type;
	GString *user_nick;
	guint64 shared_size;
	GString *user_mail;
	GString *user_description;
	guint16 user_flag;			/* user flag */
	guint16 ext_flag;			/* Extended flag */
	guint16 privilege;				/* privilege */
  /* privilege mask : 0=no
     OP_PRIV = operator
     MASTER_PRIV = master
     BOT_PRIV = bot
     HUB_PRIV = hub */
	GString *client_version;
} HUB_USER_ENTRY;

/********************************/
/* structure of a connected hub */
/********************************/
typedef struct
{
	BIN_XF_IO *hub_bxfio;				/* hub xfer information */

	/* ID information */
	guint8 remote_hub_id[HUB_ID_LEN];		/* it is a uniq ID. sample value: md5sum of "hubname-hubmacaddress" */
	char *remote_hub_name;			/* name of the remote hub */
	HUB_CNX_TYPE hc_type;

	/* routing information */
	guint32 hop_cost;	/* cost to reach this hub thru this BIN_XF_IO */

	/* connection timeout */
	time_t last_time;          /* use for Time Out */

	/* users coming from this connection */
	GHashTable *hub_users;				/* hash table of pointer of HUB_USER_ENTRY */
} HUB_CNX_ENTRY;

/***********************************/
/* structure of a cluster ID entry */
/***********************************/
typedef struct
{
	guint8 cluster_id[MD_BLOC_SIZE]; /* it is the cluster ID */

	GArray *hc_array;                /* array of HUB_CNX_ENTRY of all connected hubs in the cluster */

} CLUSTER_ENTRY;

/************************************************************/
/* function initializing the handler of all the connections */
/************************************************************/
GED_CALLBACKS *hub_cnx_entry_handler_init(void);

/* -------------------------------------------------------------------------- */
/* -------------------- creation/destruction functions ---------------------- */
/* -------------------------------------------------------------------------- */

/**********************/
/* create a new entry */
/******************************************************************************************/
/* input: bxfio to used [the pointer is stolen, the caller must ignore it after this call]*/
/******************************************************************************************/
/* output: address of the newly created and inserted HUB_CNX_ENTRY * */
/*********************************************************************/
HUB_CNX_ENTRY *hc_create_entry(BIN_XF_IO *xfio, char *hubname, HUB_CNX_TYPE hc_type,
               guint32 hop_cost, guint8 *remote_hub_id, guint8 *clus_id);

/* -------------------------------------------------------------------------- */
/* -------------------------------------------------------------------------- */
/* ------------------------ misc functions ---------------------------------- */
/* -------------------------------------------------------------------------- */
/* -------------------------------------------------------------------------- */
/************************************************************/
/* search in all clusters if a hub with the given id exists */
/************************************************************/
/* output: TRUE= the hub is here      */
/*         FALSE= the hub is not here */
/**************************************/
gboolean hub_connected(guint8 *hub_id);

/*******************************************************************/
/* append cluster and cluster's hub statistic to the given gstring */
/*******************************************************************/
void hub_cnx_append_cluster_stats(GString *output);

#endif
