/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * macro.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: macro.h,v 2.0 2003/01/30 12:50:45 eric Exp $
*/

#ifndef __MACRO_H__
#define __MACRO_H__

#define SKIP_SPACE(z)         { while((*z)&&(isspace(*z))) z++; }

#ifndef max
  #define max(a,b)     (((a)>(b))?(a):(b))
#endif

#ifndef min
  #define min(a,b)     (((a)<(b))?(a):(b))
#endif

#define ARRAY_SIZE(array) (sizeof (array) / sizeof (*(array)))

/**************************************************/
/* this macro send an event to all event handlers */
/********************************************************/
/* PERL is mandatory but Python and PLUGIN are optional */
/********************************************************/

#include "emb_perl.h"
#ifdef WITH_PYTHON
  #include "emb_python.h"
#endif
#ifdef HAVE_LIBDL
  #include "plugin.h"
#endif


#ifdef WITH_PYTHON
#ifdef HAVE_LIBDL
/*  have: PERL, Python, PLUGIN */
#define SEND_EVT_TO(param...)	{send_evt_to_script(param); send_evt_to_pscript(param); send_evt_to_plugin(param);}
#else
/*  have: PERL, Python */
#define SEND_EVT_TO(param...)	{send_evt_to_script(param); send_evt_to_pscript(param);}
#endif
#else
#ifdef HAVE_LIBDL
/*  have: PERL, PLUGIN */
#define SEND_EVT_TO(param...)	{send_evt_to_script(param); send_evt_to_plugin(param);}
#else
/*  have: PERL */
#define SEND_EVT_TO(param...)	{send_evt_to_script(param);}
#endif
#endif

#endif /* !__MACRO_H__ */
