/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * msg_list.c: Copyright (C) Dirk Rieger
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: msg_list.c,v 2.3 2003/03/07 16:02:41 ericprev Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <errno.h>
#include <glib.h>

#include "config.h"
#include "tos_key.h"
#include "msg_list.h"
#include "user_cnx_lst.h"
#include "global_user_if.h"

typedef struct
{
	GString* source_nick;
	GString* dest_nick;
	GString* msg_message;
	time_t msg_time;
} MSG_ENTRY;

/**********************/
/* arry of MSG_ENTRY */
/**********************/
static GArray *msg_array=NULL;

G_LOCK_DEFINE_STATIC(msg_array);

void add_msg_msg(LOCAL_USER_CNX_ENTRY *luce,GString **dest_base,const char *dest_nick,const GString *msg_msg)
{
	MSG_ENTRY nw;
	G_LOCK(msg_array);

	/* input initialisation */
	nw.source_nick=g_string_new(luce->user_nick->str);
	nw.dest_nick=g_string_new(dest_nick);
	nw.msg_message=g_string_new(msg_msg->str);
	time(&nw.msg_time);

	if(msg_array==NULL)
		msg_array=g_array_new(FALSE,FALSE,sizeof(MSG_ENTRY)); /* Array erstellen */

	/* append entry */
	msg_array=g_array_append_val(msg_array,nw);
	G_UNLOCK(msg_array);

	g_string_sprintfa((*dest_base),"Your message for %s was successfully stored!|",dest_nick);
	send_const_str_to_luce(luce,(*dest_base)->str);
}

void find_msg_by_nickname(LOCAL_USER_CNX_ENTRY *luce)
{
	G_LOCK(msg_array);
	if(msg_array!=NULL)
	{
		int i;
		int z=FALSE;
		GString *dest;
		const char *dest_nick=luce->user_nick->str;

		dest=g_string_new("");
		for(i=0;i<msg_array->len;i++)
		{
			MSG_ENTRY *nw;
			nw=&(g_array_index(msg_array,MSG_ENTRY,i));
			if(!strcasecmp(nw->dest_nick->str,dest_nick))
			{
				if (z==FALSE)
				{
					g_string_sprintf(dest,"$To: %s From: Kernel $<Kernel> Messages were left to you: (You have mail!) :-)\r\n",dest_nick);
					z=TRUE;
				}
				g_string_sprintfa(dest,"\r\n* %s: %s",nw->source_nick->str,nw->msg_message->str);

				if(dest->str[dest->len-1]=='|')	/* replace trailing | if it exists */
					dest->str[dest->len-1]=' ';
			}
		}
		if (z==TRUE)
		{
			g_string_sprintfa(dest,"\r\n\r\nUse the command '+clearmsg' to delete the message(s)!\r\n|");
			send_const_str_to_luce(luce,dest->str);
		}
		g_string_free(dest,TRUE);
	}
	G_UNLOCK(msg_array);

}

static inline void delete_msg_entry(int num)
{
	/* msg_array must be lock before calling this function */
	MSG_ENTRY *ad;

	ad=&(g_array_index(msg_array,MSG_ENTRY,num));
	if(ad->dest_nick)
		g_string_free(ad->dest_nick,TRUE);
	if(ad->source_nick)
		g_string_free(ad->source_nick,TRUE);
	if(ad->msg_message)
		g_string_free(ad->msg_message,TRUE);

	msg_array=g_array_remove_index_fast(msg_array,num);
}

void del_msg_entry(LOCAL_USER_CNX_ENTRY *luce, GString *dest_base)
{
	G_LOCK(msg_array);
	if(msg_array!=NULL)
	{
		int i;
		int z=FALSE;
		for(i=0;i<msg_array->len;i++)
		{
			MSG_ENTRY *nw;
			nw=&(g_array_index(msg_array,MSG_ENTRY,i));
			if(!strcasecmp(nw->dest_nick->str,luce->user_nick->str))
			{
				delete_msg_entry(i);
				z=TRUE;
			}
		}
		if (z==TRUE)
		{
			g_string_sprintfa(dest_base,"<Kernel>The message(s) was/were deleted!\r\n|");
			send_const_str_to_luce(luce,dest_base->str);
		}
	}
	G_UNLOCK(msg_array);
}

/******************************************/
/* scan tos array to find expired entries */
/******************************************/
void timeout_msg(void)
{
	time_t now;

	G_LOCK(msg_array);

	now=time(NULL);
	if(msg_array!=NULL)
	{
		int i;

		for(i=msg_array->len-1;i>=0;i--)
		{
			MSG_ENTRY *te;

			te=&(g_array_index(msg_array,MSG_ENTRY,i));

			/* remove afk-messages after 24h */
			if(te->msg_time<=(now-(3600*24)))
				delete_msg_entry(i);
		}
	}
	G_UNLOCK(msg_array);
}


