/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * multi_private_chat.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: multi_public_chat.h,v 2.7 2003/04/28 10:00:09 ericprev Exp $
*/

#ifndef __MULTI_PUBLIC_CHAT_H__
#define __MULTI_PUBLIC_CHAT_H__

#include <string.h>
#include <glib.h>

typedef enum
{
	PUBLIC_CHAT,		/* this type of chat always exists (w/ or w/o users inside) */
	PRIVATE_CHAT,		/* this type of chat is created by users and they disappear when the last user leaves */
} CHAT_TYPE;

/************************************/
/* structure of a multi public chat */
/************************************/
typedef struct
{
	GString *mpuc_nickname;
	GPtrArray *user_lst;		/* array of GString * of users in the public chat */
	int chat_id;
	CHAT_TYPE chat_type;
	gchar *password;			/* chat can be password protected */
} MPUC_ENTRY;

/***************************************************/
/* register multipublicchat user virtual functions */
/***************************************************/
void multi_public_chat_init(void);

#endif /* ! __MULTI_PUBLIC_CHAT_H__ */
