/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * passwd.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: passwd.h,v 2.1 2003/03/07 16:21:35 ericprev Exp $
*/

#ifndef __PASSWD_H__
#define __PASSWD_H__

/********************************************************/
/* verify if the username do not match the locked patern*/
/*********************************************************/
/* output: 1 if the name is lock else 0                  */
/*********************************************************/
int	is_lock_nick(const char *nick);

/*************************************************/
/* get the password associated to the given nick */
/*************************************************************/
/* output: NULL if no password required (*op_type unchanged) */
/*         else, it is the password (must be free()d when no */
/*         more required. (*op_type) is set to the type of   */
/*         "account": ==0: normal user,                      */
/*                    ==1: operator,                         */
/*                    ==2: master of the hub                 */
/*************************************************************/
char *get_user_password(char *nick, int *op_type, int *ext_type);

/**********************************************/
/* check if the given nickname has an account */
/**************************************************************/
/* output: 1=yes, 0=no. If op_type is not NULL and output==1, */
/* *op_type contains the type of "account"                    */
/*                   == 0: normal user,                       */
/*                    | OP_PRIV    : operator,                */
/*                    | MASTER_PRIV: master of the hub        */
/*                    | BOT_PRIV   : Bot                      */
/*                    | HUB_PRIV   : hub not a user           */
/**************************************************************/

int account_exist(const char *nick, int *op_type, int *extra);

/**********************************************/
/* check if the given nickname has an account */
/**************************************************************/
/* output: 1=yes, 0=no. If op_type is not NULL and output==1, */
/* *type contains the type of "account"                       */
/*                    =='N': normal user,                     */
/*                    =='O': operator,                        */
/*                    =='M': master of the hub                */
/*                    =='b': Bot                              */
/*                    =='B': Master Bot                       */
/*                    =='V': Vip                              */
/**************************************************************/

int get_account_type(const char *nick, char *type);


/************************************************************/
/* each entry of the password file has the following format */
/*
ABBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBCCCCCCCCCCCCCD
where A='F' if the entry is empty and 'U' if it is used
B...B is a 32 bytes C-string (always ended by a '\0') containing a nickname. 
  => the longest nickname takes 31 chars 
C...C is a 16 butes C-string (always ended by a '\0') containing a password. 
  => the longest password takes 15 chars               
D is a 1 byte value: D='O' if this nick is an operator, 
                     D='N' if this nick is a normal user,
                     D='M' if this nick is the master of the hub
                        (==operator + special function) 
    only the master of the hub can modify configuration and user file remotely.
************************************************************/
#define PASSWD_ENTRY (1+32+16+1)

#define NICK_PASS_POS 1
#define NICK_PASS_LEN 32
#define PASS_PASS_POS (NICK_PASS_POS+NICK_PASS_LEN)
#define PASS_PASS_LEN 16
#define TYPE_PASS_POS (PASS_PASS_POS+PASS_PASS_LEN)

/******************************************************************/
/* create the list of all registered users with their information */
/******************************************************************/
/* the returned Gstring must be freed when no more useful */
/**********************************************************/
GString *full_user_list(void);

GString *master_user_list(void);	/* same as full_user_list but only MASTER account are returned */
GString *op_user_list(void);		/* same as full_user_list but only OP account are returned */


int	gui_account_user_list();

/***********************************/
/* add a new user to the user list */
/***********************************/
/* output: 0=ok, !=0=error */
/********************************************************************/
/* note: this function doesn't perform any check of the given value */
/********************************************************************/
int add_user_to_ulist(char *nick, char *password, char account_type);

/************************************/
/* delete a user from the user list */
/************************************/
/* output: 0=ok, !=0=error */
/********************************************************************/
/* note: this function doesn't perform any check of the given value */
/********************************************************************/
int del_user_to_ulist(char *nick);

/*****************************************/
/* rename the given oldnick into newnick */
/*****************************************/
/* output: 0=ok, !=0=error */
/***************************************************************/
/* note: this function doesn't check if newnick already exists */
/***************************************************************/
int rename_user_to_ulist(char *oldnick,char *newnick);

/*********************************************/
/* change the password of the given nickname */
/*********************************************/
/* output: 0=ok, !=0=error */
/***************************/
int chg_user_passwd_to_ulist(char *nick,char *newpasswd);

/*****************************************/
/* change the type of the given nickname */
/*****************************************/
/* output: 0=ok, !=0=error */
/***************************/
int chg_user_type_to_ulist(char *nick,char newtype);


#endif
