/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * pluginT.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: pluginT.h,v 2.0 2003/01/30 12:50:45 eric Exp $
*/

#ifndef __PLUGINT_H__
#define __PLUGINT_H__

/*****************************************************************************/
/* each loaded plugin has one entry of this type in the loaded_plugins array */
/*****************************************************************************/
typedef struct
{
	char *plugin_name;   /* name of the plugin (w/o path) */
	void *handle;        /* it is the handle returned when loading the plugin with dlopen */
	GArray *evt_hdl;     /* this array contains the list of all event handlers registered by the plugin */
                        /* it is an array of PLUGIN_EVT_HANDLER entries */
} PLUGIN;

#define PLUGIN_TYPEDEF_DEFINED

#include "../plugin/dchub_plugin_api.h"

/****************************************************************************/
/* a loaded plugin can register functions to call when an event is received */
/****************************************************************************/
typedef struct
{
	char *evt_name;
	PLUGIN_EVENT_FUNCTION fnc;
} PLUGIN_EVT_HANDLER;


#endif
