<?php
/*
 * $Id: class.boPersonnel.inc.php,v 1.2.2.1 2002/02/15 02:49:54 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('bo');

class boPersonnel
{
	function add()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.htmlPersonnel');
		$obj->ShowEntryForm();
		print('<p>');
		$obj->PrintAll();
	}

	function dbadd()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbPersonnel');
		$obj->Connect();
		$obj->InitFromGlobals();
		$obj->Encrypt();
		$obj->Add();

		$objHTML = CreateObject('dcl.htmlPersonnel');
		$objHTML->PrintAll();
	}

	function modify()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbPersonnel');
		$obj->Connect();
		$obj->Load($GLOBALS['id']);
		$objHTML = CreateObject('dcl.htmlPersonnel');
		$objHTML->ShowEntryForm($obj);
	}

	function dbmodify()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbPersonnel');
		$obj->Connect();
		$obj->InitFromGlobals();
		$obj->Edit();
		$objHTML = CreateObject('dcl.htmlPersonnel');
		$objHTML->PrintAll();
	}

	function delete()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbPersonnel');
		$obj->Connect();
		$obj->Load($GLOBALS['id']);
		ShowDeleteYesNo('User', 'boPersonnel.dbdelete', $obj->id, $obj->short);
	}

	function dbdelete()
	{
		$classSubName = 'Personnel';

		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.db' . $classSubName);
		$obj->connect();
		$obj->Load($GLOBALS['id']);

		$objKey = new dclDB; // Don't really need anything fancy, 'spose...
		$noref = true;
		$objKey->connect($obj->conn);
		while ((list($table, $field) = each($obj->foreignKeys)) && $noref)
		{
			if (is_array($field)) // More than one field in here references this key
			{
				while ((list($dummykey, $onefield) = each($field)) && $noref)
				{
					$obj->Query("SELECT $onefield FROM $table WHERE $onefield=" . $GLOBALS['id']);
					if ($obj->next_record())
						$noref = false;
				}
			}
			else
			{
				$obj->Query("SELECT $field FROM $table WHERE $field=" . $GLOBALS['id']);
				if ($obj->next_record())
					$noref = false;
			}
		}

		if ($noref)
		{
			$obj->Delete();
			print(STR_BO_DELETED);
		}
		else
		{
			$obj->SetActive(false);
			print(STR_BO_DEACTIVATED);
		}

		$objHTML = CreateObject('dcl.html' . $classSubName);
		$objHTML->PrintAll();
	}

	function passwd()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_CHG_PWD']))
			return PrintPermissionDenied();

		$objPersonnel = CreateObject('dcl.htmlPersonnel');
		$objPersonnel->DisplayPasswdForm();
	}

	function dbpasswd()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_CHG_PWD']) || (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']) && $GLOBALS['DCLID'] != $GLOBALS['userid']))
			return PrintPermissionDenied();

		if ($GLOBALS['confirm'] != $GLOBALS['new'] || $GLOBALS['new'] == '')
		{
			print('<center>');
			PrintWithChocoFont(STR_BO_PASSWORDERR);
			print('</center><br>');
			$objPersonnel = CreateObject('dcl.htmlPersonnel');
			$objPersonnel->DisplayPasswdForm();
		}
		else
		{
			$objDBPersonnel = CreateObject('dcl.dbPersonnel');
			$objDBPersonnel->ChangePassword($GLOBALS['userid'], $GLOBALS['original'], $GLOBALS['new'], $GLOBALS['confirm']);
		}
	}

	function showall()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.htmlPersonnel');
		$obj->PrintAll();
	}
}
?>
