<?php
/*
 * $Id: class.dbAccounts.inc.php,v 1.2 2001/09/23 21:33:38 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('db');
class dbAccounts extends dclDB
{
	var $id;
	var $short;
	var $name;
	var $add1;
	var $add2;
	var $city;
	var $state;
	var $zip;
	var $contact;
	var $voice;
	var $fax;
	var $data1;
	var $data2;
	var $notes;
	var $active;

	function dbAccounts()
	{
           // Table Fields
		$this->fieldArray = array('id', 'short', 'name', 'add1', 'add2', 'city', 'state', 
				'zip', 'contact', 'voice', 'fax', 'data1', 'data2', 'notes', 'active');

           // Foreign keys
		$this->foreignKeys = array('workorders' => 'account');

		$this->cache = array();
		$this->cacheEnabled = true;

		$this->dclDB();
	}

	function Add()
	{
		$idSQL = $this->GetNewIDSQLForTable('accounts');
		$query = 'INSERT INTO accounts (';
		if ($idSQL != '')
			$query .= 'id,';
		$query .= 'short,name,add1,add2,city,state,zip,contact,voice,fax,data1,data2,notes,active)';
		$query .= ' VALUES (';
		if ($idSQL != '')
			$query .= $idSQL . ',';
		$query .= '\'' . $this->DBAddSlashes($this->short) . '\',';
		$query .= '\'' . $this->DBAddSlashes($this->name) . '\',';
		$query .= '\'' . $this->DBAddSlashes($this->add1) . '\',';
		$query .= '\'' . $this->DBAddSlashes($this->add2) . '\',';
		$query .= '\'' . $this->DBAddSlashes($this->city) . '\',';
		$query .= '\'' . $this->DBAddSlashes($this->state) . '\',';
		$query .= '\'' . $this->DBAddSlashes($this->zip) . '\',';
		$query .= '\'' . $this->DBAddSlashes($this->contact) . '\',';
		$query .= '\'' . $this->DBAddSlashes($this->voice) . '\',';
		$query .= '\'' . $this->DBAddSlashes($this->fax) . '\',';
		$query .= '\'' . $this->DBAddSlashes($this->data1) . '\',';
		$query .= '\'' . $this->DBAddSlashes($this->data2) . '\',';
		$query .= '\'' . $this->DBAddSlashes($this->notes) . '\',\'Y\')';

		if ($this->Insert($query) == -1)
		{
			echo '<BR>' . sprintf(STR_DB_ACCOUNTINSERTERR, $query) . '<BR>';
		}
	}

	function Edit()
	{
		$query = 'UPDATE accounts SET ';
		$query .= 'short=\'' . $this->DBAddSlashes($this->short) . '\',';
		$query .= 'name=\'' . $this->DBAddSlashes($this->name) . '\',';
		$query .= 'add1=\'' . $this->DBAddSlashes($this->add1) . '\',';
		$query .= 'add2=\'' . $this->DBAddSlashes($this->add2) . '\',';
		$query .= 'city=\'' . $this->DBAddSlashes($this->city) . '\',';
		$query .= 'state=\'' . $this->DBAddSlashes($this->state) . '\',';
		$query .= 'zip=\'' . $this->DBAddSlashes($this->zip) . '\',';
		$query .= 'contact=\'' . $this->DBAddSlashes($this->contact) . '\',';
		$query .= 'voice=\'' . $this->DBAddSlashes($this->voice) . '\',';
		$query .= 'fax=\'' . $this->DBAddSlashes($this->fax) . '\',';
		$query .= 'data1=\'' . $this->DBAddSlashes($this->data1) . '\',';
		$query .= 'data2=\'' . $this->DBAddSlashes($this->data2) . '\',';
		$query .= 'notes=\'' . $this->DBAddSlashes($this->notes) . '\',';
		$query .= 'active=\'' . $this->active . '\'';
		$query .= ' WHERE id=' . $this->id;

		$this->Execute($query);
	}

	function Delete()
	{
		$query = 'DELETE FROM accounts WHERE id=' . $this->id;
		return $this->Execute($query);
	}

	function SetActive($active)
	{
		$isActive = 'N';
		if ($active)
			$isActive = 'Y';

		$query = 'UPDATE accounts SET ';
		$query .= "active='$isActive'";
		$query .= ' WHERE id=' . $this->id;

		return $this->Execute($query);
	}

	function GetRow()
	{
		if (!$this->res)
			return -1;

		if (count($this->Record) > 0)
		{
			$this->id = $this->f('id');
			$this->short = trim($this->f('short'));
			$this->name = trim($this->f('name'));
			$this->add1 = trim($this->f('add1'));
			$this->add2 = trim($this->f('add2'));
			$this->city = trim($this->f('city'));
			$this->state = trim($this->f('state'));
			$this->zip = trim($this->f('zip'));
			$this->contact = trim($this->f('contact'));
			$this->voice = trim($this->f('voice'));
			$this->fax = trim($this->f('fax'));
			$this->data1 = trim($this->f('data1'));
			$this->data2 = trim($this->f('data2'));
			$this->notes = trim($this->f('notes'));
			$this->active = $this->f('active');

			if ($this->cacheEnabled)
				$this->CacheRow($this->id);
		}
		else
			$this->Clear();
	}

	function Load($id)
	{
		$this->Clear();

		if ($this->cacheEnabled && $this->LoadCache($id) != -1)
			return 0;

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$sql = "SELECT * FROM accounts WHERE id=$id";
		if (!$this->Query($sql))
			return -1;

		$this->next_record();
		return $this->GetRow();
	}

	function Clear()
	{
		$this->id = 0;
		$this->short = '';
		$this->name = '';
		$this->add1 = '';
		$this->add2 = '';
		$this->city = '';
		$this->state = '';
		$this->zip = '';
		$this->contact = '';
		$this->voice = '';
		$this->fax = '';
		$this->data1 = '';
		$this->data2 = '';
		$this->notes = '';
		$this->active = '';
	}
}
?>
