<?php
/*
 * $Id: class.dbChklst.inc.php,v 1.1.1.1 2001/08/09 02:38:49 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

if (!IsSet($GLOBALS['DBCHKLST_PHP3_INCLUDED']))
{
	$GLOBALS['DBCHKLST_PHP3_INCLUDED'] = 1;

	LoadStringResource('db');
	class dbChklst extends dclDB
	{
		var $dcl_chklst_id;
		var $dcl_chklst_tpl_id;
		var $dcl_chklst_summary;
		var $dcl_chklst_createby;
		var $dcl_chklst_createon;
		var $dcl_chklst_modifyby;
		var $dcl_chklst_modifyon;
		var $dcl_chklst_status;

		function dbChklst()
		{
            // Table Fields
			$this->fieldArray = array(
					'dcl_chklst_id', 
					'dcl_chklst_tpl_id', 
					'dcl_chklst_summary', 
					'dcl_chklst_createby', 
					'dcl_chklst_createon', 
					'dcl_chklst_modifyby', 
					'dcl_chklst_modifyon', 
					'dcl_chklst_status'
				);

            // Foreign keys
			$this->foreignKeys = array();

			$this->cache = array();
			$this->cacheEnabled = false;

			$this->dclDB();
		}

		function Add()
		{
			global $dcl_domain, $dcl_domain_info;

			$idSQL = $this->GetNewIDSQLForTable('dcl_chklst');
			$query = 'INSERT INTO dcl_chklst (';
			if ($idSQL != '')
				$query .= 'dcl_chklst_id,';
			$query .= 'dcl_chklst_tpl_id, dcl_chklst_summary, dcl_chklst_createby, dcl_chklst_status)';
			$query .= ' VALUES (';
			if ($idSQL != '')
				$query .= $idSQL . ',';

			$query .= $this->dcl_chklst_tpl_id . ',';
			$query .= "'" . $this->DBAddSlashes($this->dcl_chklst_summary) . "',";
			$query .= $this->dcl_chklst_createby . ',';
			$query .= "'" . $this->DBAddSlashes($this->dcl_chklst_status) . "')";

			if ($this->Insert($query) == -1)
			{
				echo '<br>' . sprintf(STR_DB_INSERTERR, $query) . '<br>';
			}
			else
			{
				if ($dcl_domain_info[$dcl_domain]['dbType'] == 'pgsql')
					$this->Query('SELECT * FROM dcl_chklst WHERE oid=' . $this->oid);
				else
					$this->Query('SELECT * FROM dcl_chklst WHERE dcl_chklst_id=' . $this->oid);

				if ($this->res)
					$this->GetRow();
				else
					printf(STR_DB_CHKLSTOIDERR, $this->oid);
			}
		}

		function Edit()
		{
			$query = 'UPDATE dcl_chklst SET ';
			$query .= 'dcl_chklst_modifyby=' . $this->dcl_chklst_modifyby . ',';
			$query .= 'dcl_chklst_modifyon=' . $this->DisplayToSQL($this->dcl_chklst_modifyon) . ',';
			$query .= "dcl_chklst_status='" . $this->DBAddSlashes($this->dcl_chklst_status) . "'";
			$query .= ' WHERE dcl_chklst_id=' . $this->dcl_chklst_id;

			$this->Execute($query);
		}

		function Delete()
		{
			$query = 'DELETE FROM dcl_chklst WHERE dcl_chklst_id=' . $this->dcl_chklst_id;
			return $this->Execute($query);
		}

		function GetRow()
		{
			if (!$this->res)
				return -1;

			if ($this->next_record())
			{
				$this->dcl_chklst_id = $this->f('dcl_chklst_id');
				$this->dcl_chklst_tpl_id = $this->f('dcl_chklst_tpl_id');
				$this->dcl_chklst_summary = $this->f('dcl_chklst_summary');
				$this->dcl_chklst_createby = $this->f('dcl_chklst_createby');
				$this->dcl_chklst_createon = $this->FormatTimestampForDisplay($this->f('dcl_chklst_createon'));
				$this->dcl_chklst_modifyby = $this->f('dcl_chklst_modifyby');
				$this->dcl_chklst_modifyon = $this->FormatTimestampForDisplay($this->f('dcl_chklst_modifyon'));
				$this->dcl_chklst_status = $this->f('dcl_chklst_status');

				if ($this->cacheEnabled)
					$this->CacheRow($this->dcl_chklst_id);
			}
			else
				$this->Clear();
		}

		function Load($id)
		{
			$this->Clear();

			if ($this->cacheEnabled && $this->LoadCache($id) != -1)
				return 0;

			if ($this->conn == 0)
			{
				if (!$this->Connect())
					return -1;
			}

			$sql = 'SELECT dcl_chklst_id, dcl_chklst_tpl_id, dcl_chklst_summary, dcl_chklst_createby, dcl_chklst_createon, ';
			$sql .= 'dcl_chklst_modifyby, dcl_chklst_modifyon, dcl_chklst_status FROM dcl_chklst WHERE ';
			$sql .= "dcl_chklst_id=$id";

			if (!$this->Query($sql))
				return -1;

			return $this->GetRow();
		}

		function Clear()
		{
			$this->dcl_chklst_id = 0;
			$this->dcl_chklst_tpl_id = 0;
			$this->dcl_chklst_summary = '';
			$this->dcl_chklst_createby = 0;
			$this->dcl_chklst_createon = '';
			$this->dcl_chklst_modifyby = 0;
			$this->dcl_chklst_modifyon = '';
			$this->dcl_chklst_status = '';
		}
	}
}
?>
